/*
 * Decompiled with CFR 0.152.
 */
package slitscan;

import application.SL;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import slitscan.ConCombine;
import slitscan.ContextIn;
import slitscan.ContextOut;

public class CombineScanner {
    public static void work(File[] in_files, ConCombine combiner, String range_label, String tracker_fn) {
        assert (in_files != null && in_files.length > 0);
        try {
            long t0 = System.nanoTime();
            ContextIn ictx = new ContextIn(in_files);
            System.out.println("in      = " + String.valueOf(ictx));
            ContextOut octx = combiner.buildContextOut(ictx);
            System.out.println("out     = " + String.valueOf(octx));
            combiner.pre();
            long t1 = System.nanoTime();
            System.out.println("pre     = " + (double)(t1 - t0) / 1000000.0);
            combiner.combine();
            long t4 = System.nanoTime();
            System.out.println("combine = " + (double)(t4 - t1) / 1000000.0);
            CombineScanner.write_pixels(combiner, 0, range_label, octx);
            CombineScanner.write_pixels(combiner, 1, range_label, octx);
            CombineScanner.write_pixels(combiner, 2, range_label, octx);
            long t5 = System.nanoTime();
            System.out.println("write   = " + (double)(t5 - t4) / 1000000.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void write_pixels(ConCombine combiner, int i, String range_label, ContextOut octx) throws IOException {
        int[] pixels = combiner.post(i);
        if (pixels != null) {
            BufferedImage out_iamge = new BufferedImage(octx.width, octx.height, 2);
            out_iamge.setRGB(0, 0, octx.width, octx.height, pixels, 0, octx.width);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
            Object output_name = SL.out_path + "combine-" + String.valueOf(combiner) + combiner.name(i) + range_label + "-" + sdf.format(new Date()) + ".png";
            output_name = ((String)output_name).replace(" ", "");
            ImageIO.write((RenderedImage)out_iamge, "png", new File((String)output_name));
            System.out.println("output  = " + (String)output_name);
        }
    }
}

