/*
 * Decompiled with CFR 0.152.
 */
package slitscan;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import slitscan.AnalysisMapper;
import slitscan.DiffDesc;
import slitscan.DiffDescComparator;

public class AnalysisScanner {
    static final int ap = Runtime.getRuntime().availableProcessors();

    public static void work(File[] in_files) {
        System.out.println("cores  = " + ap);
        assert (ap > 0) : ap;
        assert (in_files != null && in_files.length > 1);
        ArrayList<DiffDesc> diffs = new ArrayList<DiffDesc>();
        try {
            System.out.println("images = " + in_files.length);
            long t0 = System.nanoTime();
            BufferedImage ref_image = ImageIO.read(in_files[0]);
            WritableRaster ref = ref_image.getRaster();
            int i = 1;
            while (i < in_files.length) {
                BufferedImage in_image = ImageIO.read(in_files[i]);
                long diff = AnalysisScanner.map(ref, in_image);
                diffs.add(new DiffDesc(in_files[i], diff));
                ++i;
            }
            long t1 = System.nanoTime();
            System.out.println("analy  = " + (double)(t1 - t0) / 1000000.0);
            long t2 = System.nanoTime();
            Collections.sort(diffs, new DiffDescComparator());
            System.out.println("sort   = " + (double)(t2 - t1) / 1000000.0);
            int bx = 0;
            while (bx < 20 && bx < diffs.size()) {
                System.out.println("best " + bx + " = " + String.valueOf(((DiffDesc)diffs.get((int)bx)).f) + " diff = " + ((DiffDesc)diffs.get((int)bx)).d);
                ++bx;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static long map(WritableRaster ref, BufferedImage in_image) {
        int per = ref.getHeight() / ap;
        int rest = ref.getHeight() - per * (ap - 1);
        AnalysisMapper[] parallelMapper = new AnalysisMapper[ap];
        CountDownLatch mapping = new CountDownLatch(parallelMapper.length);
        int mx = 0;
        while (mx < parallelMapper.length - 1) {
            parallelMapper[mx] = new AnalysisMapper(ref, in_image.getRaster(), mx * per, per, mapping);
            parallelMapper[mx].start();
            ++mx;
        }
        parallelMapper[parallelMapper.length - 1] = new AnalysisMapper(ref, in_image.getRaster(), (ap - 1) * per, rest, mapping);
        parallelMapper[parallelMapper.length - 1].start();
        try {
            mapping.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long difference = 0L;
        int mx2 = 0;
        while (mx2 < parallelMapper.length) {
            difference += parallelMapper[mx2].diff;
            ++mx2;
        }
        return difference;
    }
}

