/*
 * Decompiled with CFR 0.152.
 */
package slitscan;

import java.awt.image.WritableRaster;
import java.util.concurrent.CountDownLatch;

class AnalysisMapper
extends Thread {
    final WritableRaster ref;
    final WritableRaster compare;
    final CountDownLatch mapping;
    final int start;
    final int len;
    final int width;
    final int[] ref_line;
    final int[] compare_line;
    final int ref_bands;
    final int compare_bands;
    long diff;

    public AnalysisMapper(WritableRaster ref, WritableRaster compare, int start, int len, CountDownLatch mapping) {
        this.ref = ref;
        this.compare = compare;
        this.start = start;
        this.len = len;
        this.mapping = mapping;
        this.width = ref.getWidth();
        this.ref_bands = ref.getNumBands();
        this.ref_line = new int[this.ref_bands * this.width * len];
        this.compare_bands = compare.getNumBands();
        this.compare_line = new int[this.compare_bands * this.width * len];
    }

    @Override
    public void run() {
        this.diff = 0L;
        try {
            this.ref.getPixels(0, 0, this.width, this.len, this.ref_line);
            this.compare.getPixels(0, 0, this.width, this.len, this.compare_line);
            int lx = 0;
            while (lx < this.len) {
                int ix = 0;
                while (ix < this.width) {
                    int rx = this.ref_bands * (lx * this.width + ix);
                    int r1 = this.ref_line[rx];
                    int g1 = this.ref_line[rx + 1];
                    int b1 = this.ref_line[rx + 2];
                    int cx = this.compare_bands * (lx * this.width + ix);
                    int r2 = this.compare_line[cx];
                    int g2 = this.compare_line[cx + 1];
                    int b2 = this.compare_line[cx + 2];
                    int rd = Math.abs(r1 - r2);
                    int gd = Math.abs(g1 - g2);
                    int bd = Math.abs(b1 - b2);
                    this.diff += (long)(rd + gd + bd);
                    ++ix;
                }
                ++lx;
            }
        }
        finally {
            this.mapping.countDown();
        }
    }
}

