/*
 * Decompiled with CFR 0.152.
 */
package noise;

import java.util.Arrays;
import noise.ImprovedNoise;
import org.junit.Assert;
import org.junit.Test;

public class ImprovedNoiseTest {
    private static final int HIST_SIZE = 25;
    private static final double STEP = 0.01;

    @Test
    public void testSigned() {
        double min;
        ImprovedNoise noise = new ImprovedNoise();
        noise.seed(1512L);
        double max = min = noise.noise(0.0, 0.0, 0.0);
        double x = -1.0;
        while (x < 1.0) {
            double y = -1.0;
            while (y < 1.0) {
                double v = noise.noise(x, y, -0.5);
                if (v < min) {
                    min = v;
                }
                if (v > max) {
                    max = v;
                }
                y += 0.01;
            }
            x += 0.01;
        }
        System.out.println("testSigned " + min + " " + max);
        Assert.assertEquals((double)-0.5230239999999999, (double)min, (double)0.0);
        Assert.assertEquals((double)0.8168563972739176, (double)max, (double)0.0);
    }

    @Test
    public void testUnsigned() {
        double min;
        ImprovedNoise noise = new ImprovedNoise();
        noise.seed(1512L);
        double max = min = noise.noise(0.0, 0.0, 0.0);
        double x = 0.0;
        while (x < 1.0) {
            double y = 0.0;
            while (y < 1.0) {
                double z = 0.0;
                while (z < 1.0) {
                    double v = noise.noise(x, y, z);
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                    z += 0.01;
                }
                y += 0.01;
            }
            x += 0.01;
        }
        System.out.println("testUnsigned " + min + " " + max);
        Assert.assertEquals((double)-0.6234952154920312, (double)min, (double)0.0);
        Assert.assertEquals((double)0.6822987627996948, (double)max, (double)0.0);
    }

    @Test
    public void testHistogram() {
        ImprovedNoise noise = new ImprovedNoise();
        noise.seed(1512L);
        int[] h = new int[25];
        double x = 0.0;
        while (x < 1.0) {
            double y = 0.0;
            while (y < 1.0) {
                double z = 0.0;
                while (z < 1.0) {
                    double v = noise.noise(x, y, z);
                    int vi = (int)(25.0 * (v + 1.0) / 2.0);
                    Assert.assertTrue((String)"vi >= 0", (vi >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)"vi < HIST_SIZE", (vi < 25 ? 1 : 0) != 0);
                    int n = vi;
                    h[n] = h[n] + 1;
                    z += 0.01;
                }
                y += 0.01;
            }
            x += 0.01;
        }
        System.out.println("testHistogram " + Arrays.toString(h));
    }
}

