/*
 * Decompiled with CFR 0.152.
 */
package application;

import filesort.Input;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import slitscan.AnalysisScanner;
import slitscan.CombineScanner;
import slitscan.ConCombine;
import slitscan.Orbit;
import slitscan.OrbitScanner;

public class SL {
    public static String default_out_path;
    public static String out_path;
    private static final String PATH = "path";
    private static final String P = "p";
    private static final String TRACK = "track";
    private static final String T = "t";
    private static final String STARTSWITH = "startswith";
    private static final String S = "s";
    private static final String ENDSWITH = "endswith";
    private static final String E = "e";
    private static final String RANGE = "range";
    private static final String R = "r";
    private static final String KERNEL1 = "kernel1";
    private static final String K1 = "k";
    private static final String KERNEL2 = "kernel2";
    private static final String K2 = "l";
    private static final String P1 = "p1";
    private static final String _1 = "1";
    private static final String P2 = "p2";
    private static final String _2 = "2";
    private static final String MIX = "mix";
    private static final String M = "m";
    private static final String OUT = "out";
    private static final String O = "o";
    private static boolean accepted;

    static {
        out_path = default_out_path = "/tmp/sl/";
        accepted = false;
    }

    public static void main(String[] args) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        System.out.println("-- " + SL.class.toString() + " -- " + sdf.format(new Date()) + " --");
        System.out.println(Arrays.toString(args).replace(", ", " "));
        Options options = new Options();
        options.addOption(P, PATH, true, "path to image files");
        options.addOption(T, TRACK, true, "motion tracking file");
        options.addOption(S, STARTSWITH, true, "file name stats with pattern");
        options.addOption(E, ENDSWITH, true, "file name ends with pattern");
        options.addOption(R, RANGE, true, "process only a limited range of input files: from,count,modulo");
        options.addOption(K1, KERNEL1, true, "this class used as first kernel");
        options.addOption(K2, KERNEL2, true, "this class used as secondary kernel");
        options.addOption(_1, P1, true, "parameters used for initializing the first kernel");
        options.addOption(_2, P2, true, "parameters used for initializing the secondary kernel");
        options.addOption(M, MIX, true, "factor for mixing both kernels");
        options.addOption(O, OUT, true, "path to output files. default is " + default_out_path);
        String kernel1 = "";
        String kernel2 = "";
        Object path = "";
        String tracker_fn = null;
        String startswith = "";
        String endswith = ".png";
        String range = "";
        String[] from_count_modulo = new String[]{};
        String p1 = "";
        String p2 = "";
        double mix = 1.0;
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(PATH)) {
                path = line.getOptionValue(PATH);
            }
            if (line.hasOption(OUT)) {
                out_path = line.getOptionValue(OUT);
            }
            if (line.hasOption(STARTSWITH)) {
                startswith = line.getOptionValue(STARTSWITH);
            }
            if (line.hasOption(ENDSWITH)) {
                endswith = line.getOptionValue(ENDSWITH);
            }
            if (line.hasOption(RANGE)) {
                range = line.getOptionValue(RANGE);
                from_count_modulo = range.split(",");
            }
            if (line.hasOption(KERNEL1)) {
                kernel1 = line.getOptionValue(KERNEL1);
            }
            if (line.hasOption(P1)) {
                p1 = line.getOptionValue(P1);
            }
            if (line.hasOption(KERNEL2)) {
                kernel2 = line.getOptionValue(KERNEL2);
            }
            if (line.hasOption(P2)) {
                p2 = line.getOptionValue(P2);
            }
            if (line.hasOption(MIX)) {
                mix = Double.parseDouble(line.getOptionValue(MIX));
            }
            if (line.hasOption(TRACK)) {
                tracker_fn = line.getOptionValue(TRACK);
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        SL.create_out_folder();
        File[] in_files = null;
        Object range_label = "";
        if (((String)path).length() > 0 && startswith.length() > 0) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            in_files = Input.listFiles(new File((String)path), startswith, endswith);
            int start = 0;
            int count = in_files.length;
            int modulo = 1;
            boolean mustReduce = false;
            if (from_count_modulo.length >= 1 && from_count_modulo[0].length() > 0 && !from_count_modulo[0].equals("*")) {
                start = Integer.parseInt(from_count_modulo[0]);
                mustReduce = true;
            }
            if (from_count_modulo.length >= 2 && from_count_modulo[1].length() > 0 && !from_count_modulo[1].equals("*")) {
                count = Integer.parseInt(from_count_modulo[1]);
                mustReduce = true;
            }
            if (from_count_modulo.length >= 3 && from_count_modulo[2].length() > 0 && !from_count_modulo[2].equals("*")) {
                modulo = Math.max(Integer.parseInt(from_count_modulo[2]), 1);
                mustReduce = true;
            }
            if (mustReduce && in_files != null) {
                in_files = SL.reduce(in_files, start, count, modulo);
                range_label = "[start=" + start + ",count=" + count + ",modulo=" + modulo + "]";
            }
        }
        if (SL.checkInput(in_files)) {
            if (kernel1.startsWith("slitscan.slit.") || kernel1.startsWith("slitscan.func.")) {
                SL.scannOrbit(kernel1, kernel2, mix, in_files, (String)range_label, p1.split(","), p2.split(","), tracker_fn);
            } else if (kernel1.startsWith("slitscan.combine.") || kernel1.startsWith("slitscan.concombine.")) {
                SL.scannCombine(kernel1, in_files, (String)range_label, p1.split(","), tracker_fn);
            } else if (kernel1.startsWith("slitscan.analysis.")) {
                accepted = in_files.length > 1;
                AnalysisScanner.work(in_files);
            }
        } else {
            System.out.println("no input images");
        }
        if (!accepted) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(SL.class.getName(), options);
        }
    }

    private static void create_out_folder() {
        File op = new File(out_path);
        if (!op.exists()) {
            op.mkdirs();
        }
        if (!op.exists() || !op.canWrite()) {
            System.out.println("can not access ouput folder '" + out_path + "'");
            System.exit(1);
        }
    }

    private static File[] reduce(File[] in_files, int from, int count, int modulo) {
        int fx = 0;
        int rx = 0;
        int mx = 0;
        while (fx < in_files.length && rx < count) {
            if (fx >= from && mx % modulo == 0) {
                ++rx;
            }
            ++mx;
            ++fx;
        }
        File[] reduced_files = new File[rx];
        fx = 0;
        rx = 0;
        mx = 0;
        while (fx < in_files.length && rx < count) {
            if (fx >= from && mx % modulo == 0) {
                reduced_files[rx++] = in_files[fx];
            }
            ++mx;
            ++fx;
        }
        return reduced_files;
    }

    private static boolean checkInput(File[] in_files) {
        return in_files != null && in_files.length > 0;
    }

    private static boolean empty(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    private static void scannOrbit(String kernel1, String kernel2, double mix, File[] in_files, String range_label, String[] p1, String[] p2, String tracker_fn) {
        try {
            Orbit orbit1 = SL.construct_kernel(kernel1, in_files, p1);
            Orbit orbit2 = SL.empty(kernel2) ? null : SL.construct_kernel(kernel2, in_files, p2);
            accepted = true;
            OrbitScanner.work(in_files, orbit1, orbit2, mix, range_label, tracker_fn);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            e.printStackTrace();
        }
    }

    private static Orbit construct_kernel(String kernel, File[] in_files, String[] p) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cls1 = Class.forName(kernel);
        Constructor<?>[] cons1 = cls1.getConstructors();
        Object[] parameters1 = new Object[]{in_files, p};
        Orbit orbit1 = (Orbit)cons1[0].newInstance(parameters1);
        return orbit1;
    }

    private static void scannCombine(String kernel, File[] in_files, String range_label, String[] p1, String tracker_fn) {
        ConCombine combiner = null;
        try {
            Class<?> cls = Class.forName(kernel);
            Constructor<?>[] cons = cls.getConstructors();
            Object[] parameters = new Object[]{in_files, p1};
            combiner = (ConCombine)cons[0].newInstance(parameters);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            e.printStackTrace();
        }
        if (combiner != null) {
            accepted = true;
            CombineScanner.work(in_files, combiner, range_label, tracker_fn);
        }
    }
}

