/*
 * Decompiled with CFR 0.152.
 */
package application;

import filesort.Input;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Interpolate {
    private static final String PATH = "path";
    private static final String P = "p";
    private static final String STARTSWITH = "startswith";
    private static final String S = "s";
    private static final String ENDSWITH = "endswith";
    private static final String E = "e";
    private static boolean accepted = false;

    public static void main(String[] args) {
        System.out.println(Arrays.toString(args).replace(", ", " "));
        Options options = new Options();
        options.addOption(P, PATH, true, "path to image files");
        options.addOption(S, STARTSWITH, true, "file name stats with pattern");
        options.addOption(E, ENDSWITH, true, "file name ends with pattern");
        Object path = "";
        String startswith = "";
        String endswith = ".png";
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(PATH)) {
                path = line.getOptionValue(PATH);
            }
            if (line.hasOption(STARTSWITH)) {
                startswith = line.getOptionValue(STARTSWITH);
            }
            if (line.hasOption(ENDSWITH)) {
                endswith = line.getOptionValue(ENDSWITH);
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        File[] in_files = null;
        if (((String)path).length() > 0 && startswith.length() > 0) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            in_files = Input.listFiles(new File((String)path), startswith, endswith);
            int in_files_len = in_files.length - 1;
            int i = 0;
            while (i < in_files_len) {
                String ii = String.format("%04d", i);
                System.out.println("convert -limit memory 2000MiB " + String.valueOf(in_files[i]) + " " + String.valueOf(in_files[i + 1]) + " -morph 8 blend-" + ii + ".png");
                ++i;
            }
            accepted = true;
        }
        if (in_files == null || in_files.length <= 0) {
            System.out.println("no input images");
        }
        if (!accepted) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(Interpolate.class.getName(), options);
        }
    }
}

