/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.util;
public class TextureRandomizer {
  public static final int MaxZufall = 0x7fff;
  public static final int unsignedMaxZufall = 0xffff;
  public static final double GaussMin = -3.0;
  public static final double GaussBreite = -2.0 * GaussMin;

  private long saat;
  private double GaussAdd;
  private double GaussFak;

  public TextureRandomizer(long initSaat) {
    saat = initSaat;
    initZufall();
  }

  public void setSaat(long initSaat) {
    saat = initSaat;
  }

  public long getSaat() {
    return saat;
  }

  public int Wahrscheinlichkeit(double wa) {
    if ((double) unsignedWuerfeln() / (double) unsignedMaxZufall < wa)
      return 1;
    else
      return 0;
  }

  public double GaussVerteilt() {
    double normal;
    normal = (double) wuerfeln() + (double) wuerfeln() + (double) wuerfeln() + (double) wuerfeln();
    return GaussFak * normal - GaussAdd;
  }

  public double gleichVerteilt() {
    return (double) wuerfeln() / (double) MaxZufall;
  }

  public double Gauss2Verteilt() {
    final double zwei_pi = 2.0 * Math.PI;
    double r2;
    r2 = gleichVerteilt();
    r2 = r2 * r2;
    return Math.sqrt(Math.log(1.0 / r2)) * Math.sin(zwei_pi * gleichVerteilt());
  }

  public double GaussIntervallVerteilt(double Intervall) {
    double zVar = Intervall * (GaussVerteilt() - GaussMin) / GaussBreite;
    if (zVar < 0.0)
      return 0.0;
    else if (zVar > Intervall)
      return Intervall;
    else
      return zVar;
  }

  public int wuerfeln() {
    saat = 22695477L * saat + 1;
    return (int) (saat >> 16) & MaxZufall;
  }

  public int unsignedWuerfeln() {
    saat = 22695477L * saat + 1;
    return (int) (saat >> 16);
  }

  private void initZufall() {
    final int AnzSummieren = 4;
    GaussAdd = Math.sqrt(3.0 * (double) AnzSummieren);
    GaussFak = 2.0 * GaussAdd / ((double) AnzSummieren * (double) MaxZufall);
  }
}
