/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.util;

import junit.framework.TestCase;
import kandid.calculation.lsys.LsysD0LCalculationTest;

/**
 * @author thomas jourdan
 *  
 */
public class NetworkHelperTest extends TestCase {

  public void testConvertToAscii() {
    {
      byte[] bin = {0,};
      assertEquals("00", NetworkHelper.convertToAscii(bin));
    }
    {
      byte[] bin = {-128,};
      assertEquals("80", NetworkHelper.convertToAscii(bin));
    }
    {
      byte[] bin = {1,};
      assertEquals("01", NetworkHelper.convertToAscii(bin));
    }
    {
      byte[] bin = {127,};
      assertEquals("7f", NetworkHelper.convertToAscii(bin));
    }
    {
      byte[] bin = {-1,};
      assertEquals("ff", NetworkHelper.convertToAscii(bin));
    }
    {
      byte[] bin = {-1, 127, 1, -128, 0};
      assertEquals("ff7f018000", NetworkHelper.convertToAscii(bin));
    }
  }

  public void testConvertToBinary() {
    byte[] expextedBin = {-1, 127, 1, -128, 0};
    byte[] calculatedBin = NetworkHelper.convertToBinary("ff7f018000");
    assertEquals(expextedBin.length, calculatedBin.length);
    for (int ix = 0; ix < expextedBin.length; ix++) {
      assertEquals(expextedBin[ix], calculatedBin[ix]);
    }
  }

  public void testCompress() {
    String predecessor[] = { "F" };
    String successor[] = { "FF-[-F+F+F]+[+F-F-F]" };
    String production = LsysD0LCalculationTest.buildProduction("F", predecessor, successor, 2);
    byte[] comp = NetworkHelper.compress(production);
    assertTrue(comp.length < production.length());
    assertEquals(production, NetworkHelper.expand(comp));
  }

  public void testSetHTTPProxy() {
    boolean httpEnabled = true;
    String host = "192.168.100.111";
    int port = 3001;
    String nonProxyHosts = "localhost";
    String username = "";
    String password = "";
    NetworkHelper.setHTTPProxy(httpEnabled, host, port, nonProxyHosts, username, password);
    assertEquals("192.168.100.111", System.getProperties().getProperty("http.proxyHost"));
    assertEquals("3001", System.getProperties().getProperty("http.proxyPort"));
    assertEquals("localhost", System.getProperties().getProperty("http.nonProxyHosts"));

    httpEnabled = false;
    host = "";
    port = 80;
    username = "";
    password = "";
    nonProxyHosts = "";
    NetworkHelper.setHTTPProxy(httpEnabled, host, port, nonProxyHosts, username, password);
    assertEquals(null, System.getProperties().getProperty("http.proxyHost"));
    assertEquals(null, System.getProperties().getProperty("http.proxyPort"));
    assertEquals(null, System.getProperties().getProperty("http.nonProxyHosts"));
  }

}