/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.util;

import junit.framework.TestCase;

/**
 * @author thomas jourdan
 */
public class CentralRandomizerTest extends TestCase {

  private static final int upperBound = 50;
  /**
   * Constructor for CentralRandomizerTest.
   * @param name
   */
  public CentralRandomizerTest(String name) {
    super(name);
  }

  public void testGetBinomial() {
    int[] hits;
    hits = binomialRun(0.0);
    assertEquals(100, hits[0]);
    assertEquals(0, hits[hits.length-1]);
    hits = binomialRun(0.25);
    assertEquals(16, hits[11]);
    hits = binomialRun(0.5);
    assertEquals(16, hits[24]);
    hits = binomialRun(0.9);
    assertEquals(22, hits[46]);
    hits = binomialRun(1.0);
    assertEquals(0, hits[0]);
    assertEquals(100, hits[hits.length-1]);
   }

  private int[] binomialRun(double probability) {
    System.out.println("binominal, probability " + probability);
    CentralRandomizer.setSeed(1512);
    int[] hits = new int[upperBound+1];
    for (int hx = 0; hx < hits.length; hx++) {
      hits[hx] = 0;      
    }
    for (int i = 0; i < 100; i++) {
      int aNumber = CentralRandomizer.getBinomial(upperBound, probability);
      assertTrue(aNumber >= 0);     
      assertTrue(aNumber <= upperBound);
      ++hits[aNumber];     
    }
    for (int hx = 0; hx < hits.length; hx++) {
      System.out.print(hx + " " + hits[hx] + " ");
      for (int sx = 0; sx < hits[hx]; sx++) {
        System.out.print("*");
      }
      System.out.println();
    }
    return hits;
  }

}
