/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.util;

import junit.framework.TestCase;

/**
 * @author thomas jourdan
 *
 */
public class Base64Test extends TestCase {

  /*
   * Class under test for String encode(String)
   */
  public void testEncodeString() {
    verifyEncode("", "");
    verifyEncode("IA==", " ");
    verifyEncode("ICA=", "  ");
    verifyEncode("DQo=", "\r\n");
    verifyEncode("PD4=", "<>");
    verifyEncode("PGFiYz4=", "<abc>");
    verifyEncode("PGFiYyBuYW1lPSJ4eXoiLyA+", "<abc name=\"xyz\"/ >");
    String text = "<abc name=\"xyz\">\r\n</abc>";
    String expected = "PGFiYyBuYW1lPSJ4eXoiPg0KPC9hYmM+";
    verifyEncode(expected, text);
  }

  /**
   * @param text
   * @param expected
   */
  private void verifyEncode(String expected, String text) {
//    Base64Encoder base64Encoder = new Base64Encoder(text);
//    String pattern1 = base64Encoder.processString();
//    assertEquals(expected, pattern1);
    
    String pattern2 = Base64.encode(text);
    assertEquals(expected, pattern2);
  }

  /*
   * Class under test for String decode(String)
   */
  public void testDecodeString() {
    verifyBoth("");
    verifyBoth(" ");
    verifyBoth("\r\n");
    verifyBoth("<abc name=\"xyz\">");
    verifyBoth("<abc name=\"xyz\" />");
  }

  /**
   * @param expected
   */
  private void verifyBoth(String expected) {
//    try {
//      Base64Encoder base64Encoder = new Base64Encoder(expected);
//      String base64data1 = base64Encoder.processString();
//      Base64Decoder base64Decoder = new Base64Decoder(base64data1);
//      String pattern1 = base64Decoder.processString();
//      assertEquals(expected, pattern1);
//    } catch (Base64FormatException exc) {
//      fail();
//    }
    
    String base64data2 = Base64.encode(expected);
    String pattern2 = Base64.decode(base64data2);
    assertEquals(expected, pattern2);
   
  }

}
