/*
 * UserComboBox.java
 * sample code from Alexander Gusev
 * Created on October 31, 2001, 9:44 PM
 */

package kandid.tree.user;

import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ComboBoxModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.DefaultComboBoxModel;

import kandid.tree.editor.ComboBoxCellEditor;
/**
 *
 * @author  Alexander Gusev
 */
public class UserComboBox extends AbstractUserObject{
    private Object   toSelect;
    private Object[] forSetValue;

    public UserComboBox(JComboBox comboBox, TreeCellEditor editor,Object[] array,Object toSelect, Object dataModel, Method dataSetter){
        super( comboBox , editor , new DefaultComboBoxModel( array ), dataModel, dataSetter );
        this.toSelect = toSelect;
        this.forSetValue = new Object[ 2 ];
    }
    public void setAfterEditing(JComponent newValue){
       toSelect =  ((JComboBox)newValue).getSelectedItem();
       sendToModel(toSelect);
    }
    public JComponent     getRenderer(){
        JComboBox box = (JComboBox) renderer;
        box.setModel( (ComboBoxModel) getRenderValue() );
        if( toSelect != null )
            box.setSelectedItem( toSelect );
        return box;
    }
    /*
     
          the setValue for ComboBoxCellEditor must to know 
          about parameters
     
     */
    public TreeCellEditor getEditor(){
        forSetValue[ 1-1 ] = getRenderValue();
        forSetValue[ 2-1 ] = toSelect;
       ((ComboBoxCellEditor)editor).setValue( forSetValue );
        return editor;
    }

    public Object getValue(){
       return toSelect;
    }
}
