/*
 * AbstractUserObject.java
 * sample code from Alexander Gusev
 * Created on November 10, 2001, 4:37 PM
 */

package kandid.tree.user;

import java.awt.Color;
import java.lang.reflect.Method;

import javax.swing.JComponent;
import javax.swing.tree.TreeCellEditor;

import kandid.util.Debug;

/**
 *
 * @author  Alexander Gusev
 * @version 
 */
public abstract class AbstractUserObject implements UserObject {

  protected Object value;
  protected JComponent renderer;
  protected TreeCellEditor editor;
  protected Color backgroundColor;
  protected Object dataModel;
  protected Method setterMethod;

  /** Creates new UserObject */
  protected AbstractUserObject(JComponent renderer, TreeCellEditor editor, Object value, Object dataModel, Method dataSetter) {
    this.renderer = renderer;
    this.editor = editor;
    this.value = value;
    this.dataModel = dataModel;
    this.setterMethod = dataSetter;
    backgroundColor = null;
  }
  
  public Object getRenderValue() {
    return value;
  }
  
  /**
   * Returns the background color.
   * @return Color
   */
  public Color getBackgroundColor() {
    return backgroundColor;
  }

  /**
   * Sets the backgroundColor.
   * @param backgroundColor The background color to set
   */
  public void setBackgroundColor(Color backgroundColor) {
    this.backgroundColor = backgroundColor;
  }

  protected void sendToModel(Object valueForModel) {
    if (dataModel != null && setterMethod != null) {
      try {
        // call setter method
        Object[] param = new Object[1];
        param[0] = valueForModel;
        setterMethod.invoke(dataModel, param);
      } catch (Exception exc) {
        Debug.stackTrace(exc);
      }
    }
  }
}
