/*
 * UserNodeRenderer.java
 * sample code from Alexander Gusev
 * Created on October 9, 2001, 4:53 PM
 */

package kandid.tree.editor;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTree;
import javax.swing.JComponent;
import javax.swing.AbstractCellEditor;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.event.CellEditorListener;

import kandid.tree.user.UserObject;
import kandid.tree.user.UserTreeNode;
/**
 *
 * @author  Alexander Gusev
 * @version 
 */
public class UserNodeEditor extends DefaultTreeCellEditor {

  UserObject user;
  CellEditorListener[] listeners = null;
  /** Creates new UserNodeRenderer */

  public UserNodeEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
    super(tree, renderer, editor);
  }
  public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {

    if (!(value instanceof UserTreeNode))
      return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);

    UserTreeNode node = (UserTreeNode) value;

    //
    //   we have a new UserObject
    //
    user = node.getUser();
    //
    //   now we must care about listeners
    //
    if (listeners == null) { // this one should be done just once
      listeners = ((AbstractCellEditor) this.realEditor).getCellEditorListeners();
    }
    this.realEditor = user.getEditor();
    // the optimization for homework
    if (listeners != null) {
      for (int i = 0; i < listeners.length; i++) {
        ((AbstractCellEditor) this.realEditor).addCellEditorListener(listeners[i]);
      }
    }

    setTree(tree);
    lastRow = row;
    determineOffset(tree, value, isSelected, expanded, leaf, row);

    if (editingComponent != null) {
      editingContainer.remove(editingComponent);
    }
    editingComponent = realEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);

    // this is kept for backwards compatabillity but isn't really needed
    // with the current BasicTreeUI implementation.
    TreePath newPath = tree.getPathForRow(row);

    canEdit = (lastPath != null && newPath != null && lastPath.equals(newPath));

    Font font = getFont();

    if (font == null) {
      if (renderer != null)
        font = renderer.getFont();
      if (font == null)
        font = tree.getFont();
    }
    editingContainer.setFont(font);
    prepareForEditing();
    return editingContainer;
  }
  public Object getCellEditorValue() {
    if (user == null)
      return super.getCellEditorValue();
    if (!(user instanceof UserObject))
      return super.getCellEditorValue();
    user.setAfterEditing((JComponent) this.editingComponent);
    return user;
  }

  protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
    /*
    if(renderer != null) {
    if(leaf)
    editingIcon = renderer.getLeafIcon();
    else if(expanded)
    editingIcon = renderer.getOpenIcon();
    else
    editingIcon = renderer.getClosedIcon();
        
    if(editingIcon != null)
    offset = renderer.getIconTextGap() +
         editingIcon.getIconWidth();
    else
    offset = renderer.getIconTextGap();
    }
    else {
    editingIcon = null;
    offset = 0;
    }
     */
    // appearance of the icons for homework
    offset = 0;
  }

}
