/*
 * TextCellEditor.java
 * sample code from Alexander Gusev
 * Created on October 9, 2001, 4:38 PM
 */

package kandid.tree.editor;

import java.awt.Component;
import java.util.EventObject;

import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;

import kandid.tree.user.SetValue;
import kandid.tree.user.UserTreeNode;
/**
 *
 * @author  Alexander Gusev
 * @version 
 */
public class TextCellEditor extends DefaultCellEditor implements SetValue {
  private static final long serialVersionUID = 1L;

  /** Creates new TextCellEditor */
  public TextCellEditor(final JTextField field) {
    super(field);
  }

  public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
    if (!(value instanceof UserTreeNode))
      return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
    return editorComponent;
  }

  public boolean shouldSelectCell(EventObject event) {
    boolean retValue = super.shouldSelectCell(event);
    getComponent().requestFocus();
    return retValue;
  }
  
  public void setValue(Object value) {
    delegate.setValue(value);
  }
}
