/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.test;

import junit.framework.TestCase;

public class FileDiffTest extends TestCase {

  /**
   * Constructor for FileDiffTest.
   * @param arg0
   */
  public FileDiffTest(String arg0) {
    super(arg0);
  }

  public void testIsEquals() {
    FileDiff fileDiff = new FileDiff();
    assertTrue(!fileDiff.isEquals("kandid/soup/test/FileDiff.java", "kandid/soup/test/FileDiffTest.java", false));
    assertTrue(fileDiff.isEquals("src/kandid/soup/test/FileDiffTest.java", "src/kandid/soup/test/FileDiffTest.java", false));
    try {
      // non existing file should NOT raise an exception, but return false
      assertTrue(!fileDiff.isEquals("non-existing-file.835791", "non-existing-file.835791", false));
      assertTrue(true);
    } catch (Exception exc) {
      assertTrue(false);
    }
  }

}
