<?xml version="1.0" encoding="UTF-8"?>
<!--
  Copyright (C) 2002 - 2025 Thomas Jourdan

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:jxb="http://java.sun.com/xml/ns/jaxb" version="1.0">

  <xsl:output method="text"/>

  <xsl:template match="xsd:schema">
    <xsl:variable name="chromosomeType" select="descendant::xsd:element[@name='chromosome']/@type"/>
		// This file was generated by the clone.xsl style sheet. 
		// Any modifications to this file will be lost upon recompilation of the style sheet or the source schema. 
		
		package kandid.soup.map;
		import javax.xml.bind.JAXBException;
		import kandid.soup.*;
		public class CloneChromosome {
			private static ObjectFactory objectFactory = new ObjectFactory();
			<xsl:apply-templates/>
	}
	</xsl:template>

  <xsl:template match="xsd:simpleType">
    <xsl:if test="descendant::xsd:annotation/xsd:appinfo/jxb:typesafeEnumClass">
		protected ^<xsl:value-of select="@name"/> clone(^<xsl:value-of select="@name"/> base) {
			^<xsl:value-of select="@name"/> newBase = ^<xsl:value-of select="@name"/>.fromValue(base.value());
			assert base.equals(newBase) : "base.equals(newBase)";
			return newBase;
		}
		</xsl:if>
	</xsl:template>


  <xsl:template match="xsd:complexType">
    <xsl:if test="contains(@name, 'Gene')">
      <xsl:variable name="geneType" select="@name"/>
      <xsl:if test="descendant::xsd:choice">
        <xsl:for-each select="descendant::xsd:choice">
          <xsl:if test="@minOccurs and @maxOccurs">
            public ^<xsl:value-of select="$geneType"/> clone(^<xsl:value-of select="$geneType"/> aGene) throws JAXBException {
              <!-- new instance  -->
              /* 1 */^<xsl:value-of select="$geneType"/> newGene = objectFactory.create^<xsl:value-of select="$geneType"/>();
              <!-- call clone for super class -->
              <xsl:for-each select="descendant::xsd:extension">
                <xsl:if test="not(@base = 'geneType')">
                  cloneMembers^<xsl:value-of select="@base"/>(newGene, aGene);
                </xsl:if>
              </xsl:for-each>
              cloneMembers^<xsl:value-of select="$geneType"/>(newGene, aGene);
              return newGene;
            }
            <xsl:for-each select="descendant::xsd:element">
            /*
              public ^<xsl:value-of select="$geneType"/> clone(^<xsl:value-of select="$geneType"/> aGene) throws JAXBException {
                <!-- new instance  -->
                !! 2 !!^<xsl:value-of select="$geneType"/> newGene = objectFactory.create^<xsl:value-of select="$geneType"/>^<xsl:value-of select="@name"/>();
                <!-- call clone for super class -->
                <xsl:for-each select="descendant::xsd:extension">
                  <xsl:if test="not(@base = 'geneType')">
                    cloneMembers^<xsl:value-of select="@base"/>(newGene, aGene);
                  </xsl:if>
                </xsl:for-each>
                cloneMembers^<xsl:value-of select="$geneType"/>^<xsl:value-of select="@name"/>(newGene, aGene);
                return newGene;
              }
              */
              /*
              private void cloneMembers^<xsl:value-of select="$geneType"/>^<xsl:value-of select="@name"/>(^<xsl:value-of select="$geneType"/> newGene, ^<xsl:value-of select="$geneType"/> aGene) throws JAXBException
              {
                <xsl:variable name="schemaBaseType" select="@type"/>
                <xsl:for-each select="/xsd:schema/xsd:complexType[@name=$schemaBaseType]/xsd:complexContent/*/xsd:sequence/xsd:element">
                  <xsl:variable name="singleSlotName" select="@name"/>
                  <xsl:variable name="singleSlotType" select="@type"/>
                  // schemaBaseType <xsl:value-of select="$schemaBaseType"/>
                  // singleSlotName <xsl:value-of select="$singleSlotName"/>
                  // type is ^<xsl:value-of select="$singleSlotType"/>
                  newGene.set^<xsl:value-of select="$singleSlotName"/>(clone(aGene.get^<xsl:value-of select="$singleSlotName"/>()));
                </xsl:for-each>
              }
              */
            </xsl:for-each>
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
      <xsl:if test="not(descendant::xsd:choice)">
        /**
         * Generateted code for deep copy of element ^<xsl:value-of select="@name"/>.
         * @param aGene element that should be copied.
         * @return deep copy of element ^<xsl:value-of select="@name"/>
         * @throws JAXBException
         */
        public ^<xsl:value-of select="@name"/> clone(^<xsl:value-of select="@name"/> aGene) throws JAXBException {
          <!-- new instance  -->
          /* 3 */^<xsl:value-of select="@name"/> newGene = objectFactory.create^<xsl:value-of select="$geneType"/>();
          <!-- call clone for super class -->
          <xsl:for-each select="descendant::xsd:extension">
            <xsl:call-template name="cloneSuper">
              <xsl:with-param name="extensionType"><xsl:value-of select="@base"/></xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
          // clone members of this class ^<xsl:value-of select="@name"/>
          cloneMembers^<xsl:value-of select="@name"/>(newGene, aGene);
          return newGene;
        }
      </xsl:if>

      
      <!-- clone members -->
      <xsl:if test="descendant::xsd:choice">
        <xsl:for-each select="descendant::xsd:choice">
          <xsl:if test="@minOccurs and @maxOccurs">
            private void cloneMembers^<xsl:value-of select="$geneType"/>(^<xsl:value-of select="$geneType"/> newGene, ^<xsl:value-of select="$geneType"/> aGene) throws JAXBException {
              java.util.List list, newList;
              int length;
              <xsl:variable name="variants" select="count(descendant::xsd:element)"/>
              list = aGene.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
              newList = newGene.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
              newList.clear();
              length = list.size();
              for(int ix=0; ix &lt; length; ++ix) {
                Object obj = list.get(ix);
                <xsl:for-each select="descendant::xsd:element">
                  if(obj instanceof ^<xsl:value-of select="$geneType"/>) {
                    newList.add(clone((^<xsl:value-of select="$geneType"/>)obj));
                  }
                </xsl:for-each>
              }
            }
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
      <xsl:if test="not(descendant::xsd:choice)">
        private void cloneMembers^<xsl:value-of select="$geneType"/>(^<xsl:value-of select="$geneType"/> newGene, ^<xsl:value-of select="$geneType"/> aGene) throws JAXBException {
          <xsl:for-each select="descendant::xsd:element">
            <xsl:variable name="schemaBaseType" select="@type"/>
            <xsl:if test="not(contains($schemaBaseType, 'Gene'))">
              <!-- members are basic data type -->
              <xsl:variable name="javaReturnType" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:annotation/xsd:appinfo/jxb:javaType/@name"/>
              <xsl:variable name="enumvalues" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:enumeration/@value"/>
              <xsl:if test="$enumvalues">
                <!-- basic data type is an enumeration -->
                //  type is an enumeration of ^<xsl:value-of select="$schemaBaseType"/>
                newGene.set^<xsl:value-of select="@name"/>(clone(aGene.get^<xsl:value-of select="@name"/>()));
              </xsl:if>
              <xsl:if test="not($enumvalues)">
                <xsl:if test="$javaReturnType = 'boolean'">
                  <!-- basic data type is boolean -->
                  //  type is boolean
                  newGene.set^<xsl:value-of select="@name"/>(aGene.is^<xsl:value-of select="@name"/>());
                </xsl:if>
                <xsl:if test="($javaReturnType = 'float') or ($javaReturnType = 'double') or ($javaReturnType = 'int') or ($javaReturnType = 'long')">
                  <!-- basic data type is double, int, long -->
                  //  type is <xsl:value-of select="$javaReturnType"/>
                  newGene.set^<xsl:value-of select="@name"/>(aGene.get^<xsl:value-of select="@name"/>());
                </xsl:if>
                <xsl:if test="$javaReturnType = 'java.lang.String'">
                  <!-- basic data type is java.lang.String -->
                  //  type is <xsl:value-of select="$javaReturnType"/>
                  newGene.set^<xsl:value-of select="@name"/>(new String(aGene.get^<xsl:value-of select="@name"/>()));
                </xsl:if>
              </xsl:if>
            </xsl:if>
            <xsl:if test="contains($schemaBaseType, 'Gene')">
              <xsl:if test="@minOccurs and @maxOccurs">
                <!-- member is list of children of class class gen -->
                <xsl:call-template name="list">
                  <xsl:with-param name="aObject">aGene</xsl:with-param>
                </xsl:call-template>
              </xsl:if>
              <xsl:if test="not(@maxOccurs)">
                <!-- member is children of class class gen -->
                //  type is ^<xsl:value-of select="$schemaBaseType"/>
                newGene.set^<xsl:value-of select="@name"/>(clone(aGene.get^<xsl:value-of select="@name"/>()));
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        }
      </xsl:if>
    </xsl:if>

    <xsl:if test="contains(@name, 'Chromosome')">
      protected void cloneMembers^<xsl:value-of select="@name"/>(^<xsl:value-of select="@name"/> newGene, ^<xsl:value-of select="@name"/> aGene) throws JAXBException {
      <xsl:for-each select="descendant::xsd:element">
        <xsl:variable name="schemaBaseType" select="@type"/>
          <xsl:if test="contains($schemaBaseType, 'Gene')">
            <xsl:if test="@minOccurs and @maxOccurs">
              <!-- member is list of children of class class gen -->
              <xsl:call-template name="list">
                <xsl:with-param name="aObject">aGene</xsl:with-param>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test="not(@maxOccurs)">
              <!-- members are children of class class gen -->
              newGene.set^<xsl:value-of select="@name"/>(clone(aGene.get^<xsl:value-of select="@name"/>()));
            </xsl:if>
          </xsl:if>
        </xsl:for-each>
      }
      
      /**
       * Generateted code for deep copy of element ^<xsl:value-of select="@name"/>.
       * @param aGene element that should be copied.
       * @return deep copy of element ^<xsl:value-of select="@name"/>
       * @throws JAXBException
       */
      public ^<xsl:value-of select="@name"/> clone(^<xsl:value-of select="@name"/> aGene) throws JAXBException {
        /* 4 */^<xsl:value-of select="@name"/> newGene = objectFactory.create^<xsl:value-of select="@name"/>();
        <!-- call clone for super class -->
        <xsl:for-each select="descendant::xsd:extension">
          <xsl:call-template name="cloneSuper">
            <xsl:with-param name="extensionType"><xsl:value-of select="@base"/></xsl:with-param>
          </xsl:call-template>
        </xsl:for-each>
        <!-- clone elements -->
        // clone members of class ^<xsl:value-of select="@name"/>
        cloneMembers^<xsl:value-of select="@name"/>(newGene, aGene);
        return newGene;
      }
    </xsl:if>
  </xsl:template>

 
  <!-- Calls cloneMember methods for all super classes. -->
  <xsl:template name="cloneSuper">
    <xsl:param name="extensionType"/>
    <xsl:if test="not(($extensionType = 'chromosomeType') or ($extensionType = 'coloratorType') or ($extensionType = 'geneType'))">
      <xsl:for-each select="/xsd:schema/xsd:complexType[@name=$extensionType]/xsd:complexContent/xsd:extension">
        <xsl:call-template name="cloneSuper">
          <xsl:with-param name="extensionType"><xsl:value-of select="@base"/></xsl:with-param>
        </xsl:call-template>
      </xsl:for-each>
      // clone members of super class ^<xsl:value-of select="$extensionType"/>
      cloneMembers^<xsl:value-of select="$extensionType"/>(newGene, aGene);
    </xsl:if>
  </xsl:template>

  
  <xsl:template name="list">
    <xsl:param name="aObject">aGene</xsl:param>
    <!-- member is list of children of class class gen -->
    // list of type ^<xsl:value-of select="@type"/>
    {
    java.util.List&lt;^<xsl:value-of select="@type"/>&gt; list = <xsl:value-of select="$aObject"/>.get^<xsl:value-of select="@name"/>();
    java.util.List&lt;^<xsl:value-of select="@type"/>&gt; newList = newGene.get^<xsl:value-of select="@name"/>();
    newList.clear();
    int length = list.size();
    for(int ix=0; ix &lt; length; ++ix) {
      newList.add(clone((^<xsl:value-of select="@type"/>)list.get(ix)));
    }
    }
  </xsl:template>
  
</xsl:stylesheet>

