// This file was generated by the random.xsl style sheet.
// Any modifications to this file will be lost upon recompilation of the style sheet or the source
// schema.
package kandid.soup.map;

import javax.xml.bind.JAXBException;
import kandid.soup.*;
import kandid.soup.genetic.lsys.LsysGenetic;

public class RandomizeChromosome {
  private static ObjectFactory objectFactory = new ObjectFactory();

  protected void randomize(
      BooleanGene aGene, ChromosomeType aChromosome, double probability, int depth)
      throws JAXBException {
    aGene.setValue(kandid.util.CentralRandomizer.getBoolean(probability));
  }

  protected void randomize(
      IntegerGene aGene,
      int minInclusive,
      int maxInclusive,
      ChromosomeType aChromosome,
      boolean binomialRamdomizer,
      double binomialProbability,
      int depth)
      throws JAXBException {
    if (binomialRamdomizer)
      aGene.setValue(
          minInclusive
              + kandid.util.CentralRandomizer.getBinomial(
                  maxInclusive - minInclusive, binomialProbability));
    else aGene.setValue(kandid.util.CentralRandomizer.getInt(minInclusive, maxInclusive));
  }

  protected void randomize(SeedGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    aGene.setValue(kandid.util.CentralRandomizer.getLong());
  }

  protected void randomize(
      DoubleGene aGene,
      double minInclusive,
      double maxInclusive,
      ChromosomeType aChromosome,
      boolean binomialRamdomizer,
      double binomialProbability,
      int depth)
      throws JAXBException {
    aGene.setValue(kandid.util.CentralRandomizer.getDouble(minInclusive, maxInclusive));
  }

  protected void randomize(NormalizedGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    aGene.setValue(kandid.util.CentralRandomizer.getDouble(0.0, 1.0));
  }

  protected void randomize(FractionalGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    aGene.setValue(kandid.util.CentralRandomizer.getDouble(0.0, 1.0));
  }

  protected void randomize(SymmetricGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    aGene.setValue(kandid.util.CentralRandomizer.getDouble(-1.0, 1.0));
  }

  protected void randomize(RandomWalkPointGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    aGene.setX(kandid.util.CentralRandomizer.getDouble(0.0, 1.0));
    aGene.setY(kandid.util.CentralRandomizer.getDouble(0.0, 1.0));
  }

  protected void randomize(ColorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    aGene.setRed(kandid.util.CentralRandomizer.getFloat((float) 0.0, (float) 1.0));
    aGene.setGreen(kandid.util.CentralRandomizer.getFloat((float) 0.0, (float) 1.0));
    aGene.setBlue(kandid.util.CentralRandomizer.getFloat((float) 0.0, (float) 1.0));
  }

  protected void randomize(HsbColorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    aGene.setHue(kandid.util.CentralRandomizer.getDouble(0.0, 1.0));
    aGene.setSaturation(kandid.util.CentralRandomizer.getDouble(0.0, 1.0));
    aGene.setBrightness(kandid.util.CentralRandomizer.getDouble(0.0, 1.0));
  }

  protected void randomize(AffineTransformationGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    SymmetricGene aTa = objectFactory.createSymmetricGene();
    randomize(aTa, aChromosome, depth + 1);
    aGene.setTa(aTa);
    SymmetricGene aTb = objectFactory.createSymmetricGene();
    randomize(aTb, aChromosome, depth + 1);
    aGene.setTb(aTb);
    SymmetricGene aTc = objectFactory.createSymmetricGene();
    randomize(aTc, aChromosome, depth + 1);
    aGene.setTc(aTc);
    SymmetricGene aTd = objectFactory.createSymmetricGene();
    randomize(aTd, aChromosome, depth + 1);
    aGene.setTd(aTd);
    SymmetricGene aTe = objectFactory.createSymmetricGene();
    randomize(aTe, aChromosome, depth + 1);
    aGene.setTe(aTe);
    SymmetricGene aTf = objectFactory.createSymmetricGene();
    randomize(aTf, aChromosome, depth + 1);
    aGene.setTf(aTf);
  }

  protected void randomize(LookUpColorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    FractionalGene aHue = objectFactory.createFractionalGene();
    randomize(aHue, aChromosome, depth + 1);
    aGene.setHue(aHue);
    NormalizedGene aSaturation = objectFactory.createNormalizedGene();
    randomize(aSaturation, aChromosome, depth + 1);
    aGene.setSaturation(aSaturation);
    NormalizedGene aBrightness = objectFactory.createNormalizedGene();
    randomize(aBrightness, aChromosome, depth + 1);
    aGene.setBrightness(aBrightness);
  }

  public void randomize(TransparentLookUpTableChromosome aChromosome) throws JAXBException {
    {
      java.util.List list = aChromosome.getLutColor();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(2, 32);
      while (newLength > 0) {
        LookUpColorGene aLutColor = objectFactory.createLookUpColorGene();
        randomize(aLutColor, aChromosome, 1);
        list.add(aLutColor);
        --newLength;
      }
    }
  }

  public void randomize(LookUpTableChromosome aChromosome) throws JAXBException {
    {
      java.util.List list = aChromosome.getLutColor();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(2, 32);
      while (newLength > 0) {
        LookUpColorGene aLutColor = objectFactory.createLookUpColorGene();
        randomize(aLutColor, aChromosome, 1);
        list.add(aLutColor);
        --newLength;
      }
    }
  }

  protected void randomize(GradientSegmentGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    FractionalGene aHue = objectFactory.createFractionalGene();
    randomize(aHue, aChromosome, depth + 1);
    aGene.setHue(aHue);
    NormalizedGene aSaturation = objectFactory.createNormalizedGene();
    randomize(aSaturation, aChromosome, depth + 1);
    aGene.setSaturation(aSaturation);
    NormalizedGene aBrightness = objectFactory.createNormalizedGene();
    randomize(aBrightness, aChromosome, depth + 1);
    aGene.setBrightness(aBrightness);
    NormalizedGene aWeight = objectFactory.createNormalizedGene();
    randomize(aWeight, aChromosome, depth + 1);
    aGene.setWeight(aWeight);
  }

  public void randomize(GradientChromosome aChromosome) throws JAXBException {
    {
      java.util.List list = aChromosome.getGradientSegment();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(2, 10);
      while (newLength > 0) {
        GradientSegmentGene aGradientSegment = objectFactory.createGradientSegmentGene();
        randomize(aGradientSegment, aChromosome, 1);
        list.add(aGradientSegment);
        --newLength;
      }
    }
  }

  public void randomize(HsbFrequenceChromosome aChromosome) throws JAXBException {
    DoubleGene aFrequence = objectFactory.createDoubleGene();
    randomize(aFrequence, 0.02, 2.0, aChromosome, false, 0.0, 1);
    aChromosome.setFrequence(aFrequence);
    SymmetricGene aPhaseshift = objectFactory.createSymmetricGene();
    randomize(aPhaseshift, aChromosome, 1);
    aChromosome.setPhaseshift(aPhaseshift);
  }

  protected void randomize(DistanceFunctionGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "abs(dx,dy)",
        "abs(dx)",
        "abs(dy)",
        "dx",
        "dy",
        "euclide(dx,dy)",
        "product(dx,dy)",
        "quotient(dx,dy)",
      };
      aGene.setDistanceFunction(
          DistanceFunctionBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
    SymmetricGene aWeight = objectFactory.createSymmetricGene();
    randomize(aWeight, aChromosome, depth + 1);
    aGene.setWeight(aWeight);
  }

  protected void randomize(KingGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    RandomWalkPointGene aPoint = objectFactory.createRandomWalkPointGene();
    randomize(aPoint, aChromosome, depth + 1);
    aGene.setPoint(aPoint);
    ColorGene aColor = objectFactory.createColorGene();
    randomize(aColor, aChromosome, depth + 1);
    aGene.setColor(aColor);
    NormalizedGene aWeight = objectFactory.createNormalizedGene();
    randomize(aWeight, aChromosome, depth + 1);
    aGene.setWeight(aWeight);
  }

  public void randomize(VoronoiChromosomeBase aChromosome) throws JAXBException {
    {
      java.util.List list = aChromosome.getDistance();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(1, 8);
      while (newLength > 0) {
        DistanceFunctionGene aDistance = objectFactory.createDistanceFunctionGene();
        randomize(aDistance, aChromosome, 1);
        list.add(aDistance);
        --newLength;
      }
    }
    {
      java.util.List list = aChromosome.getKing();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(2, 50);
      while (newLength > 0) {
        KingGene aKing = objectFactory.createKingGene();
        randomize(aKing, aChromosome, 1);
        list.add(aKing);
        --newLength;
      }
    }
  }

  public void randomize(VoronoiChromosome aChromosome) throws JAXBException {
    randomize((VoronoiChromosomeBase) aChromosome);
    SymmetricGene aYard = objectFactory.createSymmetricGene();
    randomize(aYard, aChromosome, 1);
    aChromosome.setYard(aYard);
  }

  public void randomize(VoronoiTransparentChromosome aChromosome) throws JAXBException {
    randomize((VoronoiChromosomeBase) aChromosome);
    IntegerGene aPrioritySize = objectFactory.createIntegerGene();
    randomize(aPrioritySize, 2, 10, aChromosome, false, 0.0, 1);
    aChromosome.setPrioritySize(aPrioritySize);
    DoubleGene aPriorityWeight = objectFactory.createDoubleGene();
    randomize(aPriorityWeight, 0.5, 2.0, aChromosome, false, 0.0, 1);
    aChromosome.setPriorityWeight(aPriorityWeight);
  }

  public void randomize(AffineIfsChromosome aChromosome) throws JAXBException {
    SeedGene aSeed = objectFactory.createSeedGene();
    randomize(aSeed, aChromosome, 1);
    aChromosome.setSeed(aSeed);
    {
      java.util.List list = aChromosome.getAffineTransformation();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(2, 8);
      while (newLength > 0) {
        AffineTransformationGene aAffineTransformation =
            objectFactory.createAffineTransformationGene();
        randomize(aAffineTransformation, aChromosome, 1);
        list.add(aAffineTransformation);
        --newLength;
      }
    }
  }

  public void randomize(AffineIfsSymmChromosome aChromosome) throws JAXBException {
    randomize((AffineIfsChromosome) aChromosome);
    IntegerGene aSymmetry = objectFactory.createIntegerGene();
    randomize(aSymmetry, 1, 25, aChromosome, false, 0.0, 1);
    aChromosome.setSymmetry(aSymmetry);
    BooleanGene aDn = objectFactory.createBooleanGene();
    randomize(aDn, aChromosome, 0.5, 1);
    aChromosome.setDn(aDn);
  }

  public void randomize(SymmetricIfsChromosome aChromosome) throws JAXBException {
    IntegerGene aSymmetry = objectFactory.createIntegerGene();
    randomize(aSymmetry, 3, 11, aChromosome, false, 0.0, 1);
    aChromosome.setSymmetry(aSymmetry);
    DoubleGene aLambda = objectFactory.createDoubleGene();
    randomize(aLambda, -2.5, 2.5, aChromosome, false, 0.0, 1);
    aChromosome.setLambda(aLambda);
    DoubleGene aAlpha = objectFactory.createDoubleGene();
    randomize(aAlpha, -2.5, 10.0, aChromosome, false, 0.0, 1);
    aChromosome.setAlpha(aAlpha);
    DoubleGene aBeta = objectFactory.createDoubleGene();
    randomize(aBeta, -20.0, 0.2, aChromosome, false, 0.0, 1);
    aChromosome.setBeta(aBeta);
    DoubleGene aGamma = objectFactory.createDoubleGene();
    randomize(aGamma, -1.0, 1.0, aChromosome, false, 0.0, 1);
    aChromosome.setGamma(aGamma);
    DoubleGene aOmega = objectFactory.createDoubleGene();
    randomize(aOmega, -1.0, 1.0, aChromosome, false, 0.0, 1);
    aChromosome.setOmega(aOmega);
  }

  protected void randomize(FlameTransformationGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    randomize((AffineTransformationGene) aGene, aChromosome, depth);
    NormalizedGene aWeight = objectFactory.createNormalizedGene();
    randomize(aWeight, aChromosome, depth + 1);
    aGene.setWeight(aWeight);
    NormalizedGene aColorindex = objectFactory.createNormalizedGene();
    randomize(aColorindex, aChromosome, depth + 1);
    aGene.setColorindex(aColorindex);
    BooleanGene aLinearEnabled = objectFactory.createBooleanGene();
    randomize(aLinearEnabled, aChromosome, 0.1, depth + 1);
    aGene.setLinearEnabled(aLinearEnabled);
    NormalizedGene aLinearVariation = objectFactory.createNormalizedGene();
    randomize(aLinearVariation, aChromosome, depth + 1);
    aGene.setLinearVariation(aLinearVariation);
    BooleanGene aSinusoidalEnabled = objectFactory.createBooleanGene();
    randomize(aSinusoidalEnabled, aChromosome, 0.1, depth + 1);
    aGene.setSinusoidalEnabled(aSinusoidalEnabled);
    NormalizedGene aSinusoidalVariation = objectFactory.createNormalizedGene();
    randomize(aSinusoidalVariation, aChromosome, depth + 1);
    aGene.setSinusoidalVariation(aSinusoidalVariation);
    BooleanGene aSphericalEnabled = objectFactory.createBooleanGene();
    randomize(aSphericalEnabled, aChromosome, 0.1, depth + 1);
    aGene.setSphericalEnabled(aSphericalEnabled);
    NormalizedGene aSphericalVariation = objectFactory.createNormalizedGene();
    randomize(aSphericalVariation, aChromosome, depth + 1);
    aGene.setSphericalVariation(aSphericalVariation);
    BooleanGene aSwirlEnabled = objectFactory.createBooleanGene();
    randomize(aSwirlEnabled, aChromosome, 0.1, depth + 1);
    aGene.setSwirlEnabled(aSwirlEnabled);
    NormalizedGene aSwirlVariation = objectFactory.createNormalizedGene();
    randomize(aSwirlVariation, aChromosome, depth + 1);
    aGene.setSwirlVariation(aSwirlVariation);
    BooleanGene aHorseshoeEnabled = objectFactory.createBooleanGene();
    randomize(aHorseshoeEnabled, aChromosome, 0.1, depth + 1);
    aGene.setHorseshoeEnabled(aHorseshoeEnabled);
    NormalizedGene aHorseshoeVariation = objectFactory.createNormalizedGene();
    randomize(aHorseshoeVariation, aChromosome, depth + 1);
    aGene.setHorseshoeVariation(aHorseshoeVariation);
    BooleanGene aPolarEnabled = objectFactory.createBooleanGene();
    randomize(aPolarEnabled, aChromosome, 0.1, depth + 1);
    aGene.setPolarEnabled(aPolarEnabled);
    NormalizedGene aPolarVariation = objectFactory.createNormalizedGene();
    randomize(aPolarVariation, aChromosome, depth + 1);
    aGene.setPolarVariation(aPolarVariation);
    BooleanGene aFoldedHandkerchiefEnabled = objectFactory.createBooleanGene();
    randomize(aFoldedHandkerchiefEnabled, aChromosome, 0.1, depth + 1);
    aGene.setFoldedHandkerchiefEnabled(aFoldedHandkerchiefEnabled);
    NormalizedGene aFoldedHandkerchiefVariation = objectFactory.createNormalizedGene();
    randomize(aFoldedHandkerchiefVariation, aChromosome, depth + 1);
    aGene.setFoldedHandkerchiefVariation(aFoldedHandkerchiefVariation);
    BooleanGene aHeartEnabled = objectFactory.createBooleanGene();
    randomize(aHeartEnabled, aChromosome, 0.1, depth + 1);
    aGene.setHeartEnabled(aHeartEnabled);
    NormalizedGene aHeartVariation = objectFactory.createNormalizedGene();
    randomize(aHeartVariation, aChromosome, depth + 1);
    aGene.setHeartVariation(aHeartVariation);
    BooleanGene aDiscEnabled = objectFactory.createBooleanGene();
    randomize(aDiscEnabled, aChromosome, 0.1, depth + 1);
    aGene.setDiscEnabled(aDiscEnabled);
    NormalizedGene aDiscVariation = objectFactory.createNormalizedGene();
    randomize(aDiscVariation, aChromosome, depth + 1);
    aGene.setDiscVariation(aDiscVariation);
    BooleanGene aSpiralEnabled = objectFactory.createBooleanGene();
    randomize(aSpiralEnabled, aChromosome, 0.1, depth + 1);
    aGene.setSpiralEnabled(aSpiralEnabled);
    NormalizedGene aSpiralVariation = objectFactory.createNormalizedGene();
    randomize(aSpiralVariation, aChromosome, depth + 1);
    aGene.setSpiralVariation(aSpiralVariation);
    BooleanGene aHyperbolicEnabled = objectFactory.createBooleanGene();
    randomize(aHyperbolicEnabled, aChromosome, 0.1, depth + 1);
    aGene.setHyperbolicEnabled(aHyperbolicEnabled);
    NormalizedGene aHyperbolicVariation = objectFactory.createNormalizedGene();
    randomize(aHyperbolicVariation, aChromosome, depth + 1);
    aGene.setHyperbolicVariation(aHyperbolicVariation);
    BooleanGene aDiamondEnabled = objectFactory.createBooleanGene();
    randomize(aDiamondEnabled, aChromosome, 0.1, depth + 1);
    aGene.setDiamondEnabled(aDiamondEnabled);
    NormalizedGene aDiamondVariation = objectFactory.createNormalizedGene();
    randomize(aDiamondVariation, aChromosome, depth + 1);
    aGene.setDiamondVariation(aDiamondVariation);
    BooleanGene aExEnabled = objectFactory.createBooleanGene();
    randomize(aExEnabled, aChromosome, 0.1, depth + 1);
    aGene.setExEnabled(aExEnabled);
    NormalizedGene aExVariation = objectFactory.createNormalizedGene();
    randomize(aExVariation, aChromosome, depth + 1);
    aGene.setExVariation(aExVariation);
    BooleanGene aJuliaEnabled = objectFactory.createBooleanGene();
    randomize(aJuliaEnabled, aChromosome, 0.1, depth + 1);
    aGene.setJuliaEnabled(aJuliaEnabled);
    NormalizedGene aJuliaVariation = objectFactory.createNormalizedGene();
    randomize(aJuliaVariation, aChromosome, depth + 1);
    aGene.setJuliaVariation(aJuliaVariation);
    BooleanGene aBentEnabled = objectFactory.createBooleanGene();
    randomize(aBentEnabled, aChromosome, 0.1, depth + 1);
    aGene.setBentEnabled(aBentEnabled);
    NormalizedGene aBentVariation = objectFactory.createNormalizedGene();
    randomize(aBentVariation, aChromosome, depth + 1);
    aGene.setBentVariation(aBentVariation);
    BooleanGene aFisheyeEnabled = objectFactory.createBooleanGene();
    randomize(aFisheyeEnabled, aChromosome, 0.1, depth + 1);
    aGene.setFisheyeEnabled(aFisheyeEnabled);
    NormalizedGene aFisheyeVariation = objectFactory.createNormalizedGene();
    randomize(aFisheyeVariation, aChromosome, depth + 1);
    aGene.setFisheyeVariation(aFisheyeVariation);
    BooleanGene aPopcornEnabled = objectFactory.createBooleanGene();
    randomize(aPopcornEnabled, aChromosome, 0.1, depth + 1);
    aGene.setPopcornEnabled(aPopcornEnabled);
    NormalizedGene aPopcornVariation = objectFactory.createNormalizedGene();
    randomize(aPopcornVariation, aChromosome, depth + 1);
    aGene.setPopcornVariation(aPopcornVariation);
  }

  public void randomize(FlameIfsChromosome aChromosome) throws JAXBException {
    {
      java.util.List list = aChromosome.getFlameTransformation();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(2, 8);
      while (newLength > 0) {
        FlameTransformationGene aFlameTransformation =
            objectFactory.createFlameTransformationGene();
        randomize(aFlameTransformation, aChromosome, 1);
        list.add(aFlameTransformation);
        --newLength;
      }
    }
    IntegerGene aPalette = objectFactory.createIntegerGene();
    randomize(aPalette, 0, 89, aChromosome, false, 0.0, 1);
    aChromosome.setPalette(aPalette);
    DoubleGene aHue = objectFactory.createDoubleGene();
    randomize(aHue, (-0.5), 0.5, aChromosome, false, 0.0, 1);
    aChromosome.setHue(aHue);
    DoubleGene aBrightness = objectFactory.createDoubleGene();
    randomize(aBrightness, 0.0, 5.0, aChromosome, false, 0.0, 1);
    aChromosome.setBrightness(aBrightness);
    DoubleGene aGamma = objectFactory.createDoubleGene();
    randomize(aGamma, 1.0, 5.0, aChromosome, false, 0.0, 1);
    aChromosome.setGamma(aGamma);
    DoubleGene aVibrancy = objectFactory.createDoubleGene();
    randomize(aVibrancy, 0.0, 1.0, aChromosome, false, 0.0, 1);
    aChromosome.setVibrancy(aVibrancy);
    DoubleGene aZoom = objectFactory.createDoubleGene();
    randomize(aZoom, (-4.0), 4.0, aChromosome, false, 0.0, 1);
    aChromosome.setZoom(aZoom);
    DoubleGene aFilter = objectFactory.createDoubleGene();
    randomize(aFilter, 0.0, 4.0, aChromosome, false, 0.0, 1);
    aChromosome.setFilter(aFilter);
  }

  protected void randomize(LcaInitialStateGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "uniform random",
        "random ramp",
        "single point",
        "two points",
        "three points",
        "two points with single gap",
      };
      aGene.setFillMode(
          LcaInitialStateBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
    SeedGene aStateSeed = objectFactory.createSeedGene();
    randomize(aStateSeed, aChromosome, depth + 1);
    aGene.setStateSeed(aStateSeed);
  }

  protected void randomize(LcaStateGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    // section copied from xsd:annotation/xsd:appinfo/kandid:random
    int maxStates = 0;
    if (aChromosome instanceof DirectLcaChromosome)
      maxStates = ((DirectLcaChromosome) aChromosome).getMaxStates().getValue();
    else if (aChromosome instanceof TotalLcaChromosome)
      maxStates = ((TotalLcaChromosome) aChromosome).getMaxStates().getValue();
    aGene.setValue(kandid.util.CentralRandomizer.getInt(0, maxStates - 1));
    // end section
  }

  public void randomize(LcaChromosome aChromosome) throws JAXBException {
    LcaInitialStateGene aLcaInitialState = objectFactory.createLcaInitialStateGene();
    randomize(aLcaInitialState, aChromosome, 1);
    aChromosome.setLcaInitialState(aLcaInitialState);
    IntegerGene aWidth = objectFactory.createIntegerGene();
    randomize(aWidth, 16, 512, aChromosome, false, 0.0, 1);
    aChromosome.setWidth(aWidth);
  }

  public void randomize(TotalLcaChromosome aChromosome) throws JAXBException {
    randomize((LcaChromosome) aChromosome);
    IntegerGene aMaxStates = objectFactory.createIntegerGene();
    randomize(aMaxStates, 2, 30, aChromosome, false, 0.0, 1);
    aChromosome.setMaxStates(aMaxStates);
    IntegerGene aLeftNeighbors = objectFactory.createIntegerGene();
    randomize(aLeftNeighbors, 0, 9, aChromosome, false, 0.0, 1);
    aChromosome.setLeftNeighbors(aLeftNeighbors);
    IntegerGene aRightNeighbors = objectFactory.createIntegerGene();
    randomize(aRightNeighbors, 0, 9, aChromosome, false, 0.0, 1);
    aChromosome.setRightNeighbors(aRightNeighbors);
    {
      java.util.List list = aChromosome.getColor();
      list.clear();
      int newLength = aChromosome.getMaxStates().getValue();
      while (newLength > 0) {
        ColorGene aColor = objectFactory.createColorGene();
        randomize(aColor, aChromosome, 1);
        list.add(aColor);
        --newLength;
      }
    }
    {
      java.util.List list = aChromosome.getRule();
      list.clear();
      int newLength =
          kandid.calculation.lca.TotalLcaCalculation.numberofRules(
              aChromosome.getMaxStates().getValue(),
              aChromosome.getLeftNeighbors().getValue(),
              aChromosome.getRightNeighbors().getValue());
      while (newLength > 0) {
        LcaStateGene aRule = objectFactory.createLcaStateGene();
        randomize(aRule, aChromosome, 1);
        list.add(aRule);
        --newLength;
      }
    }
  }

  public void randomize(DirectLcaChromosome aChromosome) throws JAXBException {
    randomize((LcaChromosome) aChromosome);
    IntegerGene aMaxStates = objectFactory.createIntegerGene();
    randomize(aMaxStates, 2, 6, aChromosome, false, 0.0, 1);
    aChromosome.setMaxStates(aMaxStates);
    IntegerGene aLeftNeighbors = objectFactory.createIntegerGene();
    randomize(aLeftNeighbors, 0, 2, aChromosome, false, 0.0, 1);
    aChromosome.setLeftNeighbors(aLeftNeighbors);
    IntegerGene aRightNeighbors = objectFactory.createIntegerGene();
    randomize(aRightNeighbors, 0, 2, aChromosome, false, 0.0, 1);
    aChromosome.setRightNeighbors(aRightNeighbors);
    {
      java.util.List list = aChromosome.getColor();
      list.clear();
      int newLength = aChromosome.getMaxStates().getValue();
      while (newLength > 0) {
        ColorGene aColor = objectFactory.createColorGene();
        randomize(aColor, aChromosome, 1);
        list.add(aColor);
        --newLength;
      }
    }
    {
      java.util.List list = aChromosome.getRule();
      list.clear();
      int newLength =
          kandid.calculation.lca.DirectLcaCalculation.numberofRules(
              aChromosome.getMaxStates().getValue(),
              aChromosome.getLeftNeighbors().getValue(),
              aChromosome.getRightNeighbors().getValue());
      while (newLength > 0) {
        LcaStateGene aRule = objectFactory.createLcaStateGene();
        randomize(aRule, aChromosome, 1);
        list.add(aRule);
        --newLength;
      }
    }
  }

  protected void randomize(ExprScalarOprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "ifPositive",
        "add",
        "mult",
        "sub",
        "div",
        "noise",
        "turbulence",
        "snoise",
        "sturbulence",
        "pow",
        "sqrt",
        "tan",
        "sin",
        "cos",
        "atanq",
        "atan",
        "log",
        "mix",
        "mixx",
        "step",
        "puls",
        "clamp",
        "max",
        "min",
        "abs",
        "smoothstep",
        "boxstep",
        "mod",
        "floor",
        "ceil",
        "gamma",
        "gain",
        "bias",
        "euclide",
        "absolute",
      };
      aGene.setScalarOpr(
          ExprScalarOprBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
  }

  protected void randomize(ExprScalarVarGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "x", "xi", "y", "yi", "r", "ri", "t", "ti", "xp2", "yp2", "xp3", "yp3", "xcos", "ycos",
        "xsinh", "ysinh",
      };
      aGene.setScalarVar(
          ExprScalarVarBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
  }

  protected void randomize(ExprScalarConstGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    DoubleGene aScalarConst = objectFactory.createDoubleGene();
    // xx
    randomize(aScalarConst, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setScalarConst(aScalarConst);
  }

  protected void randomize(ExprScalarArgsListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    java.util.List list = aGene.getVarOrConstOrScalarExpression();
    list.clear();
    int len = kandid.util.CentralRandomizer.getInt(2, 5);
    while (len > 0) {
      switch (kandid.util.CentralRandomizer.getInt(1, 3)) {
        case 1:
          ExprScalarVarGene aNewVar = objectFactory.createExprScalarVarGene();
          randomize(aNewVar, aChromosome, depth + 1);
          list.add(aNewVar);
          --len;
          break;
        case 2:
          ExprScalarConstGene aNewConst = objectFactory.createExprScalarConstGene();
          randomize(aNewConst, aChromosome, depth + 1);
          list.add(aNewConst);
          --len;
          break;
        case 3:
          if (kandid.util.CentralRandomizer.getDouble(0.0, 0.15) < (1.0 / depth)) {
            ScalarExprGene aNewScalarExpression = objectFactory.createScalarExprGene();
            randomize(aNewScalarExpression, aChromosome, depth + 1);
            list.add(aNewScalarExpression);
            --len;
          }
          break;
      }
    }
  }

  protected void randomize(ExprScalarListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    ExprScalarOprGene aOpr = objectFactory.createExprScalarOprGene();
    randomize(aOpr, aChromosome, depth + 1);
    aGene.setOpr(aOpr);
    ExprScalarArgsListGene aArgs = objectFactory.createExprScalarArgsListGene();
    randomize(aArgs, aChromosome, depth + 1);
    aGene.setArgs(aArgs);
  }

  protected void randomize(ScalarExprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    ExprScalarListGene aList = objectFactory.createExprScalarListGene();
    randomize(aList, aChromosome, depth + 1);
    aGene.setList(aList);
  }

  public void randomize(ScalarExpressionChromosome aChromosome) throws JAXBException {
    ScalarExprGene aScalarExpression = objectFactory.createScalarExprGene();
    randomize(aScalarExpression, aChromosome, 1);
    aChromosome.setScalarExpression(aScalarExpression);
    SeedGene aNoiseSeed = objectFactory.createSeedGene();
    randomize(aNoiseSeed, aChromosome, 1);
    aChromosome.setNoiseSeed(aNoiseSeed);
    SymmetricGene aXScale = objectFactory.createSymmetricGene();
    randomize(aXScale, aChromosome, 1);
    aChromosome.setXScale(aXScale);
    SymmetricGene aYScale = objectFactory.createSymmetricGene();
    randomize(aYScale, aChromosome, 1);
    aChromosome.setYScale(aYScale);
  }

  protected void randomize(ExprVectorOprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "add",
        "sub",
        "mult",
        "mod",
        "cross",
        "sincos",
        "atan",
        "maxvalue",
        "minvalue",
        "maxvector",
        "minvector",
        "maxmix",
        "invmix",
        "step",
        "noise",
        "turbulence",
        "waves",
      };
      aGene.setVectorOpr(
          ExprVectorOprBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
  }

  protected void randomize(ExprVectorVarGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "xyr", "xym", "xyt", "cmpow", "cmsinh", "cmim", "cmre",
      };
      aGene.setVectorVar(
          ExprVectorVarBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
  }

  protected void randomize(ExprVectorConstGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    DoubleGene aCx = objectFactory.createDoubleGene();
    // xx
    randomize(aCx, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setCx(aCx);
    DoubleGene aCy = objectFactory.createDoubleGene();
    // xx
    randomize(aCy, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setCy(aCy);
    DoubleGene aCz = objectFactory.createDoubleGene();
    // xx
    randomize(aCz, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setCz(aCz);
  }

  protected void randomize(ExprVectorArgsListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    java.util.List list = aGene.getVarOrConstOrVectorExpression();
    list.clear();
    int len = kandid.util.CentralRandomizer.getInt(2, 2);
    while (len > 0) {
      switch (kandid.util.CentralRandomizer.getInt(1, 3)) {
        case 1:
          ExprVectorVarGene aNewVar = objectFactory.createExprVectorVarGene();
          randomize(aNewVar, aChromosome, depth + 1);
          list.add(aNewVar);
          --len;
          break;
        case 2:
          ExprVectorConstGene aNewConst = objectFactory.createExprVectorConstGene();
          randomize(aNewConst, aChromosome, depth + 1);
          list.add(aNewConst);
          --len;
          break;
        case 3:
          if (kandid.util.CentralRandomizer.getDouble(0.0, 0.15) < (1.0 / depth)) {
            VectorExprGene aNewVectorExpression = objectFactory.createVectorExprGene();
            randomize(aNewVectorExpression, aChromosome, depth + 1);
            list.add(aNewVectorExpression);
            --len;
          }
          break;
      }
    }
  }

  protected void randomize(ExprVectorListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    ExprVectorOprGene aOpr = objectFactory.createExprVectorOprGene();
    randomize(aOpr, aChromosome, depth + 1);
    aGene.setOpr(aOpr);
    ExprVectorArgsListGene aArgs = objectFactory.createExprVectorArgsListGene();
    randomize(aArgs, aChromosome, depth + 1);
    aGene.setArgs(aArgs);
  }

  protected void randomize(VectorExprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    ExprVectorListGene aList = objectFactory.createExprVectorListGene();
    randomize(aList, aChromosome, depth + 1);
    aGene.setList(aList);
  }

  public void randomize(VectorExpressionChromosome aChromosome) throws JAXBException {
    VectorExprGene aVectorExpression = objectFactory.createVectorExprGene();
    randomize(aVectorExpression, aChromosome, 1);
    aChromosome.setVectorExpression(aVectorExpression);
    SeedGene aNoiseSeed = objectFactory.createSeedGene();
    randomize(aNoiseSeed, aChromosome, 1);
    aChromosome.setNoiseSeed(aNoiseSeed);
    SymmetricGene aXScale = objectFactory.createSymmetricGene();
    randomize(aXScale, aChromosome, 1);
    aChromosome.setXScale(aXScale);
    SymmetricGene aYScale = objectFactory.createSymmetricGene();
    randomize(aYScale, aChromosome, 1);
    aChromosome.setYScale(aYScale);
  }

  protected void randomize(AlphabetGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    // section copied from xsd:annotation/xsd:appinfo/kandid:random
    aGene.setValue(LsysGenetic.randomizeAlphabet((LsysChromosome) aChromosome));
    // end section
  }

  protected void randomize(AxiomGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    // section copied from xsd:annotation/xsd:appinfo/kandid:random
    aGene.setValue(LsysGenetic.randomizeAxiom((LsysChromosome) aChromosome));
    // end section
  }

  protected void randomize(IgnoreGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    // section copied from xsd:annotation/xsd:appinfo/kandid:random
    aGene.setValue(LsysGenetic.randomizeIgnore((LsysChromosome) aChromosome));
    // end section
  }

  protected void randomize(PredecessorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    // section copied from xsd:annotation/xsd:appinfo/kandid:random
    aGene.setValue(LsysGenetic.randomizePredecessor((LsysChromosome) aChromosome));
    // end section
  }

  protected void randomize(ContextGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    // section copied from xsd:annotation/xsd:appinfo/kandid:random
    aGene.setValue(LsysGenetic.randomizeContext((LsysChromosome) aChromosome));
    // end section
  }

  protected void randomize(SuccessorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    // section copied from xsd:annotation/xsd:appinfo/kandid:random
    aGene.setValue(LsysGenetic.randomizeSuccessor((LsysChromosome) aChromosome));
    // end section
  }

  protected void randomize(LsysProductionGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    PredecessorGene aPredecessor = objectFactory.createPredecessorGene();
    randomize(aPredecessor, aChromosome, depth + 1);
    aGene.setPredecessor(aPredecessor);
    SuccessorGene aSuccessor = objectFactory.createSuccessorGene();
    randomize(aSuccessor, aChromosome, depth + 1);
    aGene.setSuccessor(aSuccessor);
    ContextGene aLeftContext = objectFactory.createContextGene();
    randomize(aLeftContext, aChromosome, depth + 1);
    aGene.setLeftContext(aLeftContext);
    ContextGene aRightContext = objectFactory.createContextGene();
    randomize(aRightContext, aChromosome, depth + 1);
    aGene.setRightContext(aRightContext);
  }

  public void randomize(LsysChromosome aChromosome) throws JAXBException {
    AlphabetGene aAlphabet = objectFactory.createAlphabetGene();
    randomize(aAlphabet, aChromosome, 1);
    aChromosome.setAlphabet(aAlphabet);
    AxiomGene aAxiom = objectFactory.createAxiomGene();
    randomize(aAxiom, aChromosome, 1);
    aChromosome.setAxiom(aAxiom);
    {
      java.util.List list = aChromosome.getProduction();
      list.clear();
      int newLength = LsysGenetic.getNumberOfProductions(aChromosome);
      while (newLength > 0) {
        LsysProductionGene aProduction = objectFactory.createLsysProductionGene();
        randomize(aProduction, aChromosome, 1);
        list.add(aProduction);
        --newLength;
      }
    }
    IntegerGene aDirections = objectFactory.createIntegerGene();
    randomize(aDirections, 1, 36, aChromosome, false, 0.0, 1);
    aChromosome.setDirections(aDirections);
    IntegerGene aBaseIndex = objectFactory.createIntegerGene();
    randomize(aBaseIndex, 0, 256, aChromosome, false, 0.0, 1);
    aChromosome.setBaseIndex(aBaseIndex);
  }

  public void randomize(LsysD0LChromosome aChromosome) throws JAXBException {
    randomize((LsysChromosome) aChromosome);
    IntegerGene aDepth = objectFactory.createIntegerGene();
    randomize(aDepth, 1, 12, aChromosome, true, 0.4, 1);
    aChromosome.setDepth(aDepth);
  }

  public void randomize(Lsys0LChromosome aChromosome) throws JAXBException {
    randomize((LsysChromosome) aChromosome);
    IntegerGene aDepth = objectFactory.createIntegerGene();
    randomize(aDepth, 1, 12, aChromosome, true, 0.4, 1);
    aChromosome.setDepth(aDepth);
    IntegerGene aJitter = objectFactory.createIntegerGene();
    randomize(aJitter, 0, 100, aChromosome, false, 0.0, 1);
    aChromosome.setJitter(aJitter);
    SeedGene aNoiseSeed = objectFactory.createSeedGene();
    randomize(aNoiseSeed, aChromosome, 1);
    aChromosome.setNoiseSeed(aNoiseSeed);
  }

  public void randomize(LsysILChromosome aChromosome) throws JAXBException {
    randomize((LsysChromosome) aChromosome);
    IgnoreGene aIgnore = objectFactory.createIgnoreGene();
    randomize(aIgnore, aChromosome, 1);
    aChromosome.setIgnore(aIgnore);
    IntegerGene aDepth = objectFactory.createIntegerGene();
    randomize(aDepth, 1, 12, aChromosome, true, 0.4, 1);
    aChromosome.setDepth(aDepth);
    IntegerGene aJitter = objectFactory.createIntegerGene();
    randomize(aJitter, 0, 100, aChromosome, false, 0.0, 1);
    aChromosome.setJitter(aJitter);
    SeedGene aNoiseSeed = objectFactory.createSeedGene();
    randomize(aNoiseSeed, aChromosome, 1);
    aChromosome.setNoiseSeed(aNoiseSeed);
  }

  protected void randomize(NormalizedVector3Gene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    NormalizedGene aX = objectFactory.createNormalizedGene();
    randomize(aX, aChromosome, depth + 1);
    aGene.setX(aX);
    NormalizedGene aY = objectFactory.createNormalizedGene();
    randomize(aY, aChromosome, depth + 1);
    aGene.setY(aY);
    NormalizedGene aZ = objectFactory.createNormalizedGene();
    randomize(aZ, aChromosome, depth + 1);
    aGene.setZ(aZ);
  }

  protected void randomize(Matrix4X3Gene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    DoubleGene aVal00 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal00, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal00(aVal00);
    DoubleGene aVal01 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal01, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal01(aVal01);
    DoubleGene aVal02 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal02, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal02(aVal02);
    DoubleGene aVal10 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal10, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal10(aVal10);
    DoubleGene aVal11 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal11, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal11(aVal11);
    DoubleGene aVal12 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal12, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal12(aVal12);
    DoubleGene aVal20 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal20, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal20(aVal20);
    DoubleGene aVal21 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal21, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal21(aVal21);
    DoubleGene aVal22 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal22, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal22(aVal22);
    DoubleGene aVal30 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal30, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal30(aVal30);
    DoubleGene aVal31 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal31, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal31(aVal31);
    DoubleGene aVal32 = objectFactory.createDoubleGene();
    // xx
    randomize(aVal32, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setVal32(aVal32);
  }

  protected void randomize(PovTurbulenceWarpGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    NormalizedVector3Gene aTurbulenceVector = objectFactory.createNormalizedVector3Gene();
    randomize(aTurbulenceVector, aChromosome, depth + 1);
    aGene.setTurbulenceVector(aTurbulenceVector);
    IntegerGene aOctaves = objectFactory.createIntegerGene();
    // xx
    randomize(aOctaves, 1, 6, aChromosome, false, 0.0, depth + 1);
    aGene.setOctaves(aOctaves);
    DoubleGene aOmega = objectFactory.createDoubleGene();
    // xx
    randomize(aOmega, 0.01, 0.99, aChromosome, false, 0.0, depth + 1);
    aGene.setOmega(aOmega);
    DoubleGene aLambda = objectFactory.createDoubleGene();
    // xx
    randomize(aLambda, 1.0, 2.5, aChromosome, false, 0.0, depth + 1);
    aGene.setLambda(aLambda);
  }

  protected void randomize(PovBlackHoleWarpGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    NormalizedVector3Gene aLocation = objectFactory.createNormalizedVector3Gene();
    randomize(aLocation, aChromosome, depth + 1);
    aGene.setLocation(aLocation);
    NormalizedGene aRadius = objectFactory.createNormalizedGene();
    randomize(aRadius, aChromosome, depth + 1);
    aGene.setRadius(aRadius);
    DoubleGene aFalloff = objectFactory.createDoubleGene();
    // xx
    randomize(aFalloff, 0.1, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setFalloff(aFalloff);
    NormalizedGene aStrength = objectFactory.createNormalizedGene();
    randomize(aStrength, aChromosome, depth + 1);
    aGene.setStrength(aStrength);
    BooleanGene aInvers = objectFactory.createBooleanGene();
    randomize(aInvers, aChromosome, 0.5, depth + 1);
    aGene.setInvers(aInvers);
  }

  protected void randomize(HsbftGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    randomize((HsbColorGene) aGene, aChromosome, depth);
    NormalizedGene aFilter = objectFactory.createNormalizedGene();
    randomize(aFilter, aChromosome, depth + 1);
    aGene.setFilter(aFilter);
    NormalizedGene aTransmit = objectFactory.createNormalizedGene();
    randomize(aTransmit, aChromosome, depth + 1);
    aGene.setTransmit(aTransmit);
  }

  protected void randomize(ColorMapEntryGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    NormalizedGene aWeight = objectFactory.createNormalizedGene();
    randomize(aWeight, aChromosome, depth + 1);
    aGene.setWeight(aWeight);
    HsbftGene aHsbft = objectFactory.createHsbftGene();
    randomize(aHsbft, aChromosome, depth + 1);
    aGene.setHsbft(aHsbft);
  }

  protected void randomize(PovColorMapGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "boxed",
        "bozo",
        "bumps",
        "cells",
        "cylindrical",
        "dents",
        "granite",
        "leopard",
        "marble",
        "onion",
        "planar",
        "radial",
        "ripples",
        "spherical",
        "spotted",
        "waves",
        "wood",
        "wrinkles",
      };
      aGene.setMapPattern(
          PovMapPatternBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
    {
      java.util.List list = aGene.getColor();
      list.clear();
      int newLength = 2 + kandid.util.CentralRandomizer.getBinomial(256 - 2, 0.01);
      while (newLength > 0) {
        ColorMapEntryGene aColor = objectFactory.createColorMapEntryGene();
        randomize(aColor, aChromosome, 1);
        list.add(aColor);
        --newLength;
      }
    }
  }

  protected void randomize(PovTransformMapGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    Matrix4X3Gene aMatrix = objectFactory.createMatrix4X3Gene();
    randomize(aMatrix, aChromosome, depth + 1);
    aGene.setMatrix(aMatrix);
    BooleanGene aInvers = objectFactory.createBooleanGene();
    randomize(aInvers, aChromosome, 0.5, depth + 1);
    aGene.setInvers(aInvers);
  }

  protected void randomize(PovWarpGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    PovTurbulenceWarpGene aTurbulence = objectFactory.createPovTurbulenceWarpGene();
    randomize(aTurbulence, aChromosome, depth + 1);
    aGene.setTurbulence(aTurbulence);
    {
      java.util.List list = aGene.getBlackHole();
      list.clear();
      int newLength = 0 + kandid.util.CentralRandomizer.getBinomial(10 - 0, 0.2);
      while (newLength > 0) {
        PovBlackHoleWarpGene aBlackHole = objectFactory.createPovBlackHoleWarpGene();
        randomize(aBlackHole, aChromosome, 1);
        list.add(aBlackHole);
        --newLength;
      }
    }
  }

  protected void randomize(PovBlendGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "ramp_wave", "triangle_wave", "sine_wave", "scallop_wave", "cubic_wave", "poly_wave",
      };
      aGene.setBlendMapModifier(
          PovBlendMapModifierBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
    DoubleGene aBlendMapFrequency = objectFactory.createDoubleGene();
    // xx
    randomize(aBlendMapFrequency, 0.1, 10.0, aChromosome, false, 0.0, depth + 1);
    aGene.setBlendMapFrequency(aBlendMapFrequency);
    DoubleGene aBlendMapPhase = objectFactory.createDoubleGene();
    // xx
    randomize(aBlendMapPhase, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setBlendMapPhase(aBlendMapPhase);
  }

  protected void randomize(PovPigmentGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    PovColorMapGene aColorMap = objectFactory.createPovColorMapGene();
    randomize(aColorMap, aChromosome, depth + 1);
    aGene.setColorMap(aColorMap);
    PovWarpGene aWarp = objectFactory.createPovWarpGene();
    randomize(aWarp, aChromosome, depth + 1);
    aGene.setWarp(aWarp);
    PovTransformMapGene aTransform = objectFactory.createPovTransformMapGene();
    randomize(aTransform, aChromosome, depth + 1);
    aGene.setTransform(aTransform);
    PovBlendGene aBlend = objectFactory.createPovBlendGene();
    randomize(aBlend, aChromosome, depth + 1);
    aGene.setBlend(aBlend);
  }

  protected void randomize(NormalMapEntryGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    NormalizedGene aWeight = objectFactory.createNormalizedGene();
    randomize(aWeight, aChromosome, depth + 1);
    aGene.setWeight(aWeight);
    {
      String enumNames[] = {
        "boxed",
        "bozo",
        "bumps",
        "cells",
        "cylindrical",
        "dents",
        "granite",
        "leopard",
        "marble",
        "onion",
        "planar",
        "radial",
        "ripples",
        "spherical",
        "spotted",
        "waves",
        "wood",
        "wrinkles",
      };
      aGene.setMapPattern(
          PovMapPatternBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
    DoubleGene aDepth = objectFactory.createDoubleGene();
    // xx
    randomize(aDepth, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setDepth(aDepth);
    DoubleGene aBumpSize = objectFactory.createDoubleGene();
    // xx
    randomize(aBumpSize, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setBumpSize(aBumpSize);
    PovWarpGene aWarp = objectFactory.createPovWarpGene();
    randomize(aWarp, aChromosome, depth + 1);
    aGene.setWarp(aWarp);
    PovTransformMapGene aTransform = objectFactory.createPovTransformMapGene();
    randomize(aTransform, aChromosome, depth + 1);
    aGene.setTransform(aTransform);
  }

  protected void randomize(PovNormalMapGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    BooleanGene aAverage = objectFactory.createBooleanGene();
    randomize(aAverage, aChromosome, 0.25, depth + 1);
    aGene.setAverage(aAverage);
    {
      String enumNames[] = {
        "boxed",
        "bozo",
        "bumps",
        "cells",
        "cylindrical",
        "dents",
        "granite",
        "leopard",
        "marble",
        "onion",
        "planar",
        "radial",
        "ripples",
        "spherical",
        "spotted",
        "waves",
        "wood",
        "wrinkles",
      };
      aGene.setMapPattern(
          PovMapPatternBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
    {
      java.util.List list = aGene.getNormal();
      list.clear();
      int newLength = 2 + kandid.util.CentralRandomizer.getBinomial(256 - 2, 0.001);
      while (newLength > 0) {
        NormalMapEntryGene aNormal = objectFactory.createNormalMapEntryGene();
        randomize(aNormal, aChromosome, 1);
        list.add(aNormal);
        --newLength;
      }
    }
  }

  protected void randomize(PovNormalGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    PovNormalMapGene aNormalMap = objectFactory.createPovNormalMapGene();
    randomize(aNormalMap, aChromosome, depth + 1);
    aGene.setNormalMap(aNormalMap);
    PovWarpGene aWarp = objectFactory.createPovWarpGene();
    randomize(aWarp, aChromosome, depth + 1);
    aGene.setWarp(aWarp);
    PovTransformMapGene aTransform = objectFactory.createPovTransformMapGene();
    randomize(aTransform, aChromosome, depth + 1);
    aGene.setTransform(aTransform);
    PovBlendGene aBlend = objectFactory.createPovBlendGene();
    randomize(aBlend, aChromosome, depth + 1);
    aGene.setBlend(aBlend);
  }

  protected void randomize(PovReflectionGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    HsbftGene aColor = objectFactory.createHsbftGene();
    randomize(aColor, aChromosome, depth + 1);
    aGene.setColor(aColor);
    BooleanGene aMetallic = objectFactory.createBooleanGene();
    randomize(aMetallic, aChromosome, 0.5, depth + 1);
    aGene.setMetallic(aMetallic);
  }

  protected void randomize(PovFinishGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    DoubleGene aAmbient = objectFactory.createDoubleGene();
    // xx
    randomize(aAmbient, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setAmbient(aAmbient);
    DoubleGene aDiffuse = objectFactory.createDoubleGene();
    // xx
    randomize(aDiffuse, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setDiffuse(aDiffuse);
    DoubleGene aSpecular = objectFactory.createDoubleGene();
    // xx
    randomize(aSpecular, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setSpecular(aSpecular);
    DoubleGene aRoughness = objectFactory.createDoubleGene();
    // xx
    randomize(aRoughness, 0.001, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setRoughness(aRoughness);
    BooleanGene aMetallic = objectFactory.createBooleanGene();
    randomize(aMetallic, aChromosome, 0.5, depth + 1);
    aGene.setMetallic(aMetallic);
    PovReflectionGene aReflection = objectFactory.createPovReflectionGene();
    randomize(aReflection, aChromosome, depth + 1);
    aGene.setReflection(aReflection);
  }

  protected void randomize(PovTextureLayerGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    PovPigmentGene aPigment = objectFactory.createPovPigmentGene();
    randomize(aPigment, aChromosome, depth + 1);
    aGene.setPigment(aPigment);
  }

  protected void randomize(PovThingGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {}

  public void randomize(PovThingChromosome aChromosome) throws JAXBException {
    PovThingGene aThing = objectFactory.createPovThingGene();
    randomize(aThing, aChromosome, 1);
    aChromosome.setThing(aThing);
    {
      java.util.List list = aChromosome.getTextureLayer();
      list.clear();
      int newLength = 2 + kandid.util.CentralRandomizer.getBinomial(20 - 2, 0.1);
      while (newLength > 0) {
        PovTextureLayerGene aTextureLayer = objectFactory.createPovTextureLayerGene();
        randomize(aTextureLayer, aChromosome, 1);
        list.add(aTextureLayer);
        --newLength;
      }
    }
  }

  public void randomize(PovThingNFChromosome aChromosome) throws JAXBException {
    randomize((PovThingChromosome) aChromosome);
    PovNormalGene aNormal = objectFactory.createPovNormalGene();
    randomize(aNormal, aChromosome, 1);
    aChromosome.setNormal(aNormal);
    PovFinishGene aFinish = objectFactory.createPovFinishGene();
    randomize(aFinish, aChromosome, 1);
    aChromosome.setFinish(aFinish);
  }

  protected void randomize(ExprSdlOprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "add", "mult", "sub", "div", "max", "min", "mod", "noise", "snoise", "atanq", "pow", "sqrt",
        "pow", "abs", "acos", "acosh", "asin", "asinh", "atan", "atanh", "ceil", "cos", "cosh",
        "degrees", "exp", "floor", "ln", "log", "radians", "sin", "sinh", "sqrt", "tan", "tanh",
      };
      aGene.setSdlOpr(
          ExprSdlOprBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
  }

  protected void randomize(ExprSdlVarGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      String enumNames[] = {
        "x", "y", "z",
      };
      aGene.setSdlVar(
          ExprSdlVarBase.fromValue(
              new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length - 1)])));
    }
  }

  protected void randomize(ExprSdlConstGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    DoubleGene aSdlConst = objectFactory.createDoubleGene();
    // xx
    randomize(aSdlConst, -1.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setSdlConst(aSdlConst);
  }

  protected void randomize(ExprSdlArgsListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    java.util.List list = aGene.getVarOrConstOrSdlExpression();
    list.clear();
    int len = kandid.util.CentralRandomizer.getInt(2, 5);
    while (len > 0) {
      switch (kandid.util.CentralRandomizer.getInt(1, 3)) {
        case 1:
          ExprSdlVarGene aNewVar = objectFactory.createExprSdlVarGene();
          randomize(aNewVar, aChromosome, depth + 1);
          list.add(aNewVar);
          --len;
          break;
        case 2:
          ExprSdlConstGene aNewConst = objectFactory.createExprSdlConstGene();
          randomize(aNewConst, aChromosome, depth + 1);
          list.add(aNewConst);
          --len;
          break;
        case 3:
          if (kandid.util.CentralRandomizer.getDouble(0.0, 0.15) < (1.0 / depth)) {
            SdlExpressionGene aNewSdlExpression = objectFactory.createSdlExpressionGene();
            randomize(aNewSdlExpression, aChromosome, depth + 1);
            list.add(aNewSdlExpression);
            --len;
          }
          break;
      }
    }
  }

  protected void randomize(ExprSdlListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    ExprSdlOprGene aOpr = objectFactory.createExprSdlOprGene();
    randomize(aOpr, aChromosome, depth + 1);
    aGene.setOpr(aOpr);
    ExprSdlArgsListGene aArgs = objectFactory.createExprSdlArgsListGene();
    randomize(aArgs, aChromosome, depth + 1);
    aGene.setArgs(aArgs);
  }

  protected void randomize(SdlExpressionGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    ExprSdlListGene aList = objectFactory.createExprSdlListGene();
    randomize(aList, aChromosome, depth + 1);
    aGene.setList(aList);
  }

  protected void randomize(PovRotateGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    DoubleGene aRx = objectFactory.createDoubleGene();
    // xx
    randomize(aRx, -180.0, 180.0, aChromosome, false, 0.0, depth + 1);
    aGene.setRx(aRx);
    DoubleGene aRy = objectFactory.createDoubleGene();
    // xx
    randomize(aRy, -180.0, 180.0, aChromosome, false, 0.0, depth + 1);
    aGene.setRy(aRy);
    DoubleGene aRz = objectFactory.createDoubleGene();
    // xx
    randomize(aRz, -180.0, 180.0, aChromosome, false, 0.0, depth + 1);
    aGene.setRz(aRz);
  }

  protected void randomize(PovRidgedMultifractalGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    ExprSdlListGene aFx = objectFactory.createExprSdlListGene();
    randomize(aFx, aChromosome, depth + 1);
    aGene.setFx(aFx);
    ExprSdlListGene aFy = objectFactory.createExprSdlListGene();
    randomize(aFy, aChromosome, depth + 1);
    aGene.setFy(aFy);
    ExprSdlListGene aFz = objectFactory.createExprSdlListGene();
    randomize(aFz, aChromosome, depth + 1);
    aGene.setFz(aFz);
    DoubleGene aH = objectFactory.createDoubleGene();
    // xx
    randomize(aH, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setH(aH);
    DoubleGene aLacunarity = objectFactory.createDoubleGene();
    // xx
    randomize(aLacunarity, 1.0, 100.0, aChromosome, false, 0.0, depth + 1);
    aGene.setLacunarity(aLacunarity);
    IntegerGene aOctaves = objectFactory.createIntegerGene();
    // xx
    randomize(aOctaves, 1, 6, aChromosome, false, 0.0, depth + 1);
    aGene.setOctaves(aOctaves);
    DoubleGene aOffset = objectFactory.createDoubleGene();
    // xx
    randomize(aOffset, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setOffset(aOffset);
    DoubleGene aGain = objectFactory.createDoubleGene();
    // xx
    randomize(aGain, 0.0, 1.0, aChromosome, false, 0.0, depth + 1);
    aGene.setGain(aGain);
  }

  public void randomize(PovIsoSurfaceChromosome aChromosome) throws JAXBException {
    randomize((PovThingNFChromosome) aChromosome);
    PovRidgedMultifractalGene aRidgedMultifractal = objectFactory.createPovRidgedMultifractalGene();
    randomize(aRidgedMultifractal, aChromosome, 1);
    aChromosome.setRidgedMultifractal(aRidgedMultifractal);
    NormalizedGene aThreshold = objectFactory.createNormalizedGene();
    randomize(aThreshold, aChromosome, 1);
    aChromosome.setThreshold(aThreshold);
    PovRotateGene aRotate = objectFactory.createPovRotateGene();
    randomize(aRotate, aChromosome, 1);
    aChromosome.setRotate(aRotate);
  }

  protected void randomize(AbstractTutorialShapeGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    ColorGene aColor = objectFactory.createColorGene();
    randomize(aColor, aChromosome, depth + 1);
    aGene.setColor(aColor);
    NormalizedGene aTransparency = objectFactory.createNormalizedGene();
    randomize(aTransparency, aChromosome, depth + 1);
    aGene.setTransparency(aTransparency);
    SymmetricGene aX = objectFactory.createSymmetricGene();
    randomize(aX, aChromosome, depth + 1);
    aGene.setX(aX);
    SymmetricGene aY = objectFactory.createSymmetricGene();
    randomize(aY, aChromosome, depth + 1);
    aGene.setY(aY);
  }

  protected void randomize(TutorialCircleGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    randomize((AbstractTutorialShapeGene) aGene, aChromosome, depth);
    NormalizedGene aRadius = objectFactory.createNormalizedGene();
    randomize(aRadius, aChromosome, depth + 1);
    aGene.setRadius(aRadius);
  }

  public void randomize(TutorialShapeChromosome aChromosome) throws JAXBException {
    {
      java.util.List list = aChromosome.getAllShapes();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(2, 100);
      while (newLength > 0) {
        TutorialCircleGene aAllShapes = objectFactory.createTutorialCircleGene();
        randomize(aAllShapes, aChromosome, 1);
        list.add(aAllShapes);
        --newLength;
      }
    }
    ColorGene aColor = objectFactory.createColorGene();
    randomize(aColor, aChromosome, 1);
    aChromosome.setColor(aColor);
  }

  protected void randomize(WarpingTurbulenceGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    SymmetricGene aTimeCoord = objectFactory.createSymmetricGene();
    randomize(aTimeCoord, aChromosome, depth + 1);
    aGene.setTimeCoord(aTimeCoord);
    DoubleGene aOctaves = objectFactory.createDoubleGene();
    // xx
    randomize(aOctaves, 0.0, 7.0, aChromosome, false, 0.0, depth + 1);
    aGene.setOctaves(aOctaves);
    DoubleGene aAmpscale = objectFactory.createDoubleGene();
    // xx
    randomize(aAmpscale, 0.2, 0.8, aChromosome, false, 0.0, depth + 1);
    aGene.setAmpscale(aAmpscale);
    DoubleGene aFreqscale = objectFactory.createDoubleGene();
    // xx
    randomize(aFreqscale, 1.0, 4.0, aChromosome, false, 0.0, depth + 1);
    aGene.setFreqscale(aFreqscale);
    SymmetricGene aScaleOut = objectFactory.createSymmetricGene();
    randomize(aScaleOut, aChromosome, depth + 1);
    aGene.setScaleOut(aScaleOut);
    SymmetricGene aScaleXin = objectFactory.createSymmetricGene();
    randomize(aScaleXin, aChromosome, depth + 1);
    aGene.setScaleXin(aScaleXin);
    SymmetricGene aScaleYin = objectFactory.createSymmetricGene();
    randomize(aScaleYin, aChromosome, depth + 1);
    aGene.setScaleYin(aScaleYin);
    NormalizedGene aSource1 = objectFactory.createNormalizedGene();
    randomize(aSource1, aChromosome, depth + 1);
    aGene.setSource1(aSource1);
    NormalizedGene aSource2 = objectFactory.createNormalizedGene();
    randomize(aSource2, aChromosome, depth + 1);
    aGene.setSource2(aSource2);
    NormalizedGene aSource3 = objectFactory.createNormalizedGene();
    randomize(aSource3, aChromosome, depth + 1);
    aGene.setSource3(aSource3);
    NormalizedGene aSource4 = objectFactory.createNormalizedGene();
    randomize(aSource4, aChromosome, depth + 1);
    aGene.setSource4(aSource4);
    SeedGene aSeed1 = objectFactory.createSeedGene();
    randomize(aSeed1, aChromosome, depth + 1);
    aGene.setSeed1(aSeed1);
    SeedGene aSeed2 = objectFactory.createSeedGene();
    randomize(aSeed2, aChromosome, depth + 1);
    aGene.setSeed2(aSeed2);
    SeedGene aSeed3 = objectFactory.createSeedGene();
    randomize(aSeed3, aChromosome, depth + 1);
    aGene.setSeed3(aSeed3);
    SeedGene aSeed4 = objectFactory.createSeedGene();
    randomize(aSeed4, aChromosome, depth + 1);
    aGene.setSeed4(aSeed4);
  }

  protected void randomize(WarpingLayerGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    {
      java.util.List list = aGene.getTerm();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(1, 2);
      while (newLength > 0) {
        WarpingTurbulenceGene aTerm = objectFactory.createWarpingTurbulenceGene();
        randomize(aTerm, aChromosome, 1);
        list.add(aTerm);
        --newLength;
      }
    }
  }

  public void randomize(DomainWarpingChromosome aChromosome) throws JAXBException {
    DoubleGene aMainscale = objectFactory.createDoubleGene();
    randomize(aMainscale, 0.1, 10.0, aChromosome, false, 0.0, 1);
    aChromosome.setMainscale(aMainscale);
    DoubleGene aGradientgain = objectFactory.createDoubleGene();
    randomize(aGradientgain, 0.001, 0.999, aChromosome, false, 0.0, 1);
    aChromosome.setGradientgain(aGradientgain);
    {
      java.util.List list = aChromosome.getWarpingLayer();
      list.clear();
      int newLength = kandid.util.CentralRandomizer.getInt(1, 5);
      while (newLength > 0) {
        WarpingLayerGene aWarpingLayer = objectFactory.createWarpingLayerGene();
        randomize(aWarpingLayer, aChromosome, 1);
        list.add(aWarpingLayer);
        --newLength;
      }
    }
  }

  public void randomize(DomainWarpingChladniNoiseChromosome aChromosome) throws JAXBException {
    randomize((DomainWarpingChromosome) aChromosome);
  }

  public void randomize(DomainWarpingChladniWorleyNoiseChromosome aChromosome)
      throws JAXBException {
    randomize((DomainWarpingChromosome) aChromosome);
  }

  public void randomize(DomainWarpingChladniWorleyPerlinNoiseChromosome aChromosome)
      throws JAXBException {
    randomize((DomainWarpingChromosome) aChromosome);
  }
}
