// This file was generated by the mutate.xsl style sheet.
// Any modifications to this file will be lost upon recompilation of the style sheet or the source
// schema.
package kandid.soup.map;

import javax.xml.bind.JAXBException;
import kandid.soup.*;
import kandid.soup.genetic.lsys.LsysGenetic;

public class MutateChromosome extends RandomizeChromosome {
  private static ObjectFactory objectFactory = new ObjectFactory();

  private int mutateListLength(kandid.Environment env, int min, int max, int oldLength) {
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      int newLength =
          (int)
              Math.ceil(
                  oldLength
                      + (Math.log(oldLength + 1) * kandid.util.CentralRandomizer.getGaussian()));
      if (newLength < min) {
        newLength = min;
      } else if (newLength > max) {
        newLength = max;
      }
      return newLength;
    } else {
      return oldLength;
    }
  }

  private void cutList(int cutTo, java.util.List list) {
    int length = list.size();
    while (length > cutTo) {
      --length;
      list.remove(length);
    }
  }

  private int scrambleList(kandid.Environment env, java.util.List list) {
    int mutationCounter = 0;
    int length = list.size();
    if (length > 1) {
      if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
        int g1 = kandid.util.CentralRandomizer.getInt(length - 1);
        int g2 = kandid.util.CentralRandomizer.getInt(length - 1);
        if (g1 != g2) {
          Object temp = list.get(g1);
          list.set(g1, list.get(g2));
          list.set(g2, temp);
          ++mutationCounter;
        }
      }
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, BooleanGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      boolean oldValue = aGene.isValue();
      boolean newValue = kandid.util.CentralRandomizer.getBoolean();
      aGene.setValue(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env,
      IntegerGene aGene,
      int minInclusive,
      int maxInclusive,
      ChromosomeType aChromosome,
      int depth) {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      if (kandid.util.CentralRandomizer.getBoolean()) {
        int value = aGene.getValue();
        if (value > minInclusive) {
          aGene.setValue(aGene.getValue() - 1);
          ++mutationCounter;
        }
      } else {
        int value = aGene.getValue();
        if (value < maxInclusive) {
          aGene.setValue(aGene.getValue() + 1);
          ++mutationCounter;
        }
      }
      // end section
    }
    return mutationCounter;
  }

  private int mutate(kandid.Environment env, SeedGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      long oldValue = aGene.getValue();
      long newValue = kandid.util.CentralRandomizer.getLong();
      aGene.setValue(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env,
      DoubleGene aGene,
      double minInclusive,
      double maxInclusive,
      ChromosomeType aChromosome,
      int depth) {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      double oldValue = aGene.getValue();
      double newValue =
          oldValue + env.getScaleFactor() * kandid.util.CentralRandomizer.getGaussian();
      if (newValue < minInclusive) newValue = minInclusive;
      else if (newValue > maxInclusive) newValue = maxInclusive;
      aGene.setValue(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, NormalizedGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      double oldValue = aGene.getValue();
      double newValue =
          oldValue + env.getScaleFactor() * kandid.util.CentralRandomizer.getGaussian();
      if (newValue < 0.0) newValue = 0.0;
      else if (newValue > 1.0) newValue = 1.0;
      aGene.setValue(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, FractionalGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      double oldValue = aGene.getValue();
      double newValue =
          oldValue + env.getScaleFactor() * kandid.util.CentralRandomizer.getGaussian();
      while (newValue < 0.0) newValue += 1.0;
      while (newValue > 1.0) newValue -= 1.0;
      aGene.setValue(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, SymmetricGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      double oldValue = aGene.getValue();
      double newValue =
          oldValue + env.getScaleFactor() * kandid.util.CentralRandomizer.getGaussian();
      if (newValue < -1.0) newValue = -1.0;
      else if (newValue > 1.0) newValue = 1.0;
      aGene.setValue(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, RandomWalkPointGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      double radius = kandid.util.CentralRandomizer.getDouble(env.getScaleFactor());
      double angle = kandid.util.CentralRandomizer.getDouble(-Math.PI, Math.PI);
      aGene.setX(aGene.getX() + radius * Math.cos(angle));
      aGene.setY(aGene.getY() + radius * Math.sin(angle));
      ++mutationCounter;
      // end section
    }
    // mutate members
    return mutationCounter;
  }

  private int mutate(kandid.Environment env, ColorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      kandid.colorator.ColorF32 rgb =
          new kandid.colorator.ColorF32(aGene.getRed(), aGene.getGreen(), aGene.getBlue());
      kandid.colorator.ColorF32 hsb = new kandid.colorator.ColorF32();
      kandid.colorator.ColorF32 old = new kandid.colorator.ColorF32();
      kandid.colorator.ColorF32.rgb2hsb(rgb, hsb);
      kandid.colorator.ColorF32.copy(rgb, old);
      double scale = env.getScaleFactor();
      // hue
      hsb.r = hsb.r + (float) (scale * kandid.util.CentralRandomizer.getGaussian());
      while (hsb.r < 0.0) {
        hsb.r += 1.0;
      }
      while (hsb.r > 1.0) {
        hsb.r -= 1.0;
      }
      // saturation
      hsb.g = hsb.g + (float) (scale * kandid.util.CentralRandomizer.getGaussian());
      if (hsb.g < 0.0) {
        hsb.g = 0.0f;
      } else if (hsb.g > 1.0) {
        hsb.g = 1.0f;
      }
      // brightness
      hsb.b = hsb.b + (float) (scale * kandid.util.CentralRandomizer.getGaussian());
      if (hsb.b < 0.0) {
        hsb.b = 0.0f;
      } else if (hsb.b > 1.0) {
        hsb.b = 1.0f;
      }
      kandid.colorator.ColorF32.hsb2rgb(hsb, rgb);
      aGene.setRed(rgb.r);
      aGene.setGreen(rgb.g);
      aGene.setBlue(rgb.b);
      mutationCounter += ((old.r != rgb.r) || (old.g != rgb.g) || (old.b != rgb.b)) ? 1 : 0;
      // end section
    }
    // mutate members
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, HsbColorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      double scale = env.getScaleFactor();
      double hue = aGene.getHue() + (scale * kandid.util.CentralRandomizer.getGaussian());
      while (hue < 0.0) {
        hue += 1.0;
      }
      while (hue > 1.0) {
        hue -= 1.0;
      }
      double saturation =
          aGene.getSaturation() + (scale * kandid.util.CentralRandomizer.getGaussian());
      if (saturation < 0.0) {
        saturation = 0.0f;
      } else if (saturation > 1.0) {
        saturation = 1.0f;
      }
      double brightness =
          aGene.getBrightness() + (scale * kandid.util.CentralRandomizer.getGaussian());
      if (brightness < 0.0) {
        brightness = 0.0f;
      } else if (brightness > 1.0) {
        brightness = 1.0f;
      }
      aGene.setHue(hue);
      aGene.setSaturation(saturation);
      aGene.setBrightness(brightness);
      mutationCounter += 1;
      // end section
    }
    // mutate members
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, AffineTransformationGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getTa(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTb(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTc(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTd(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTe(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTf(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, LookUpColorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getHue(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSaturation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getBrightness(), aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, TransparentLookUpTableChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen lutColor
      java.util.List list = aChromosome.getLutColor();
      // calculate new length of lutColor list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 32, oldLength);
      // cut lutColor list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (LookUpColorGene) iter.next(), aChromosome, 1);
      }
      // append elements to lutColor list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ LookUpColorGene newGene = objectFactory.createLookUpColorGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, LookUpTableChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen lutColor
      java.util.List list = aChromosome.getLutColor();
      // calculate new length of lutColor list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 32, oldLength);
      // cut lutColor list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (LookUpColorGene) iter.next(), aChromosome, 1);
      }
      // append elements to lutColor list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ LookUpColorGene newGene = objectFactory.createLookUpColorGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, GradientSegmentGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getHue(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSaturation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getBrightness(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, GradientChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen gradientSegment
      java.util.List list = aChromosome.getGradientSegment();
      // calculate new length of gradientSegment list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 10, oldLength);
      // cut gradientSegment list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (GradientSegmentGene) iter.next(), aChromosome, 1);
      }
      // append elements to gradientSegment list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ GradientSegmentGene newGene = objectFactory.createGradientSegmentGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, HsbFrequenceChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getFrequence(), 0.02, 2.0, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getPhaseshift(), aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, DistanceFunctionGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesDistanceFunction[] = {
      "abs(dx,dy)",
      "abs(dx)",
      "abs(dy)",
      "dx",
      "dy",
      "euclide(dx,dy)",
      "product(dx,dy)",
      "quotient(dx,dy)",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      DistanceFunctionBase oldValue = aGene.getDistanceFunction();
      DistanceFunctionBase newValue =
          DistanceFunctionBase.fromValue(
              enumNamesDistanceFunction[
                  kandid.util.CentralRandomizer.getInt(enumNamesDistanceFunction.length - 1)]);
      aGene.setDistanceFunction(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    mutationCounter += mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(kandid.Environment env, KingGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getPoint(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getColor(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, VoronoiChromosomeBase aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen distance
      java.util.List list = aChromosome.getDistance();
      // calculate new length of distance list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 1, 8, oldLength);
      // cut distance list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (DistanceFunctionGene) iter.next(), aChromosome, 1);
      }
      // append elements to distance list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ DistanceFunctionGene newGene = objectFactory.createDistanceFunctionGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    {
      // mutate list for gen king
      java.util.List list = aChromosome.getKing();
      // calculate new length of king list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 50, oldLength);
      // cut king list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (KingGene) iter.next(), aChromosome, 1);
      }
      // append elements to king list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ KingGene newGene = objectFactory.createKingGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, VoronoiChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (VoronoiChromosomeBase) aChromosome);
    mutationCounter += mutate(env, aChromosome.getYard(), aChromosome, 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, VoronoiTransparentChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (VoronoiChromosomeBase) aChromosome);
    mutationCounter += mutate(env, aChromosome.getPrioritySize(), 2, 10, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getPriorityWeight(), 0.5, 2.0, aChromosome, 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, AffineIfsChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getSeed(), aChromosome, 1);
    {
      // mutate list for gen affineTransformation
      java.util.List list = aChromosome.getAffineTransformation();
      // calculate new length of affineTransformation list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 8, oldLength);
      // cut affineTransformation list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (AffineTransformationGene) iter.next(), aChromosome, 1);
      }
      // append elements to affineTransformation list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ AffineTransformationGene newGene = objectFactory.createAffineTransformationGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, AffineIfsSymmChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (AffineIfsChromosome) aChromosome);
    mutationCounter += mutate(env, aChromosome.getSymmetry(), 1, 25, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getDn(), aChromosome, 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, SymmetricIfsChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getSymmetry(), 3, 11, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getLambda(), -2.5, 2.5, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getAlpha(), -2.5, 10.0, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getBeta(), -20.0, 0.2, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getGamma(), -1.0, 1.0, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getOmega(), -1.0, 1.0, aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, FlameTransformationGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // call mutation for super class
    mutationCounter += mutate(env, (AffineTransformationGene) aGene, aChromosome, depth + 1);
    // mutate members
    mutationCounter += mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getColorindex(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getLinearEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getLinearVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSinusoidalEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSinusoidalVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSphericalEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSphericalVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSwirlEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSwirlVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getHorseshoeEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getHorseshoeVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getPolarEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getPolarVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getFoldedHandkerchiefEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getFoldedHandkerchiefVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getHeartEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getHeartVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getDiscEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getDiscVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSpiralEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSpiralVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getHyperbolicEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getHyperbolicVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getDiamondEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getDiamondVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getExEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getExVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getJuliaEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getJuliaVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getBentEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getBentVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getFisheyeEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getFisheyeVariation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getPopcornEnabled(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getPopcornVariation(), aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, FlameIfsChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen flameTransformation
      java.util.List list = aChromosome.getFlameTransformation();
      // calculate new length of flameTransformation list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 8, oldLength);
      // cut flameTransformation list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (FlameTransformationGene) iter.next(), aChromosome, 1);
      }
      // append elements to flameTransformation list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ FlameTransformationGene newGene = objectFactory.createFlameTransformationGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    mutationCounter += mutate(env, aChromosome.getPalette(), 0, 89, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getHue(), (-0.5), 0.5, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getBrightness(), 0.0, 5.0, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getGamma(), 1.0, 5.0, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getVibrancy(), 0.0, 1.0, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getZoom(), (-4.0), 4.0, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getFilter(), 0.0, 4.0, aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, LcaInitialStateGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesFillMode[] = {
      "uniform random",
      "random ramp",
      "single point",
      "two points",
      "three points",
      "two points with single gap",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      LcaInitialStateBase oldValue = aGene.getFillMode();
      LcaInitialStateBase newValue =
          LcaInitialStateBase.fromValue(
              enumNamesFillMode[
                  kandid.util.CentralRandomizer.getInt(enumNamesFillMode.length - 1)]);
      aGene.setFillMode(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    mutationCounter += mutate(env, aGene.getStateSeed(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, LcaStateGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      double test = kandid.util.CentralRandomizer.getGaussian();
      if (kandid.util.CentralRandomizer.getBoolean()) {
        int value = aGene.getValue();
        if (value > 0) {
          aGene.setValue(aGene.getValue() - 1);
          ++mutationCounter;
        }
      } else {
        int value = aGene.getValue();
        int maxStates = 0;
        if (aChromosome instanceof DirectLcaChromosome)
          maxStates = ((DirectLcaChromosome) aChromosome).getMaxStates().getValue();
        else if (aChromosome instanceof TotalLcaChromosome)
          maxStates = ((TotalLcaChromosome) aChromosome).getMaxStates().getValue();
        if (value < maxStates - 1) {
          aGene.setValue(aGene.getValue() + 1);
          ++mutationCounter;
        }
      }
      // end section
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, LcaChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getLcaInitialState(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getWidth(), 16, 512, aChromosome, 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, TotalLcaChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (LcaChromosome) aChromosome);
    mutationCounter += mutate(env, aChromosome.getMaxStates(), 2, 30, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getLeftNeighbors(), 0, 9, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getRightNeighbors(), 0, 9, aChromosome, 1);
    {
      // mutate list for gen color
      java.util.List list = aChromosome.getColor();
      // calculate new length of color list
      int oldLength = list.size();
      int newLength = aChromosome.getMaxStates().getValue();
      // cut color list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (ColorGene) iter.next(), aChromosome, 1);
      }
      // append elements to color list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ ColorGene newGene = objectFactory.createColorGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    {
      // mutate list for gen rule
      java.util.List list = aChromosome.getRule();
      // calculate new length of rule list
      int oldLength = list.size();
      int newLength =
          kandid.calculation.lca.TotalLcaCalculation.numberofRules(
              aChromosome.getMaxStates().getValue(),
              aChromosome.getLeftNeighbors().getValue(),
              aChromosome.getRightNeighbors().getValue());
      // cut rule list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (LcaStateGene) iter.next(), aChromosome, 1);
      }
      // append elements to rule list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ LcaStateGene newGene = objectFactory.createLcaStateGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      int length = list.size();
      int ix = 0;
      // adjust upper bound for each element
      while (ix < length) {
        LcaStateGene element = (LcaStateGene) list.get(ix);
        if (element.getValue() > (aChromosome.getMaxStates().getValue() - 1)) {
          element.setValue(aChromosome.getMaxStates().getValue() - 1);
          ++mutationCounter;
        }
        ++ix;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, DirectLcaChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (LcaChromosome) aChromosome);
    mutationCounter += mutate(env, aChromosome.getMaxStates(), 2, 6, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getLeftNeighbors(), 0, 2, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getRightNeighbors(), 0, 2, aChromosome, 1);
    {
      // mutate list for gen color
      java.util.List list = aChromosome.getColor();
      // calculate new length of color list
      int oldLength = list.size();
      int newLength = aChromosome.getMaxStates().getValue();
      // cut color list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (ColorGene) iter.next(), aChromosome, 1);
      }
      // append elements to color list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ ColorGene newGene = objectFactory.createColorGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    {
      // mutate list for gen rule
      java.util.List list = aChromosome.getRule();
      // calculate new length of rule list
      int oldLength = list.size();
      int newLength =
          kandid.calculation.lca.DirectLcaCalculation.numberofRules(
              aChromosome.getMaxStates().getValue(),
              aChromosome.getLeftNeighbors().getValue(),
              aChromosome.getRightNeighbors().getValue());
      // cut rule list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (LcaStateGene) iter.next(), aChromosome, 1);
      }
      // append elements to rule list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ LcaStateGene newGene = objectFactory.createLcaStateGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      int length = list.size();
      int ix = 0;
      // adjust upper bound for each element
      while (ix < length) {
        LcaStateGene element = (LcaStateGene) list.get(ix);
        if (element.getValue() > (aChromosome.getMaxStates().getValue() - 1)) {
          element.setValue(aChromosome.getMaxStates().getValue() - 1);
          ++mutationCounter;
        }
        ++ix;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprScalarOprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesScalarOpr[] = {
      "ifPositive",
      "add",
      "mult",
      "sub",
      "div",
      "noise",
      "turbulence",
      "snoise",
      "sturbulence",
      "pow",
      "sqrt",
      "tan",
      "sin",
      "cos",
      "atanq",
      "atan",
      "log",
      "mix",
      "mixx",
      "step",
      "puls",
      "clamp",
      "max",
      "min",
      "abs",
      "smoothstep",
      "boxstep",
      "mod",
      "floor",
      "ceil",
      "gamma",
      "gain",
      "bias",
      "euclide",
      "absolute",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      ExprScalarOprBase oldValue = aGene.getScalarOpr();
      ExprScalarOprBase newValue =
          ExprScalarOprBase.fromValue(
              enumNamesScalarOpr[
                  kandid.util.CentralRandomizer.getInt(enumNamesScalarOpr.length - 1)]);
      aGene.setScalarOpr(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprScalarVarGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesScalarVar[] = {
      "x", "xi", "y", "yi", "r", "ri", "t", "ti", "xp2", "yp2", "xp3", "yp3", "xcos", "ycos",
      "xsinh", "ysinh",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      ExprScalarVarBase oldValue = aGene.getScalarVar();
      ExprScalarVarBase newValue =
          ExprScalarVarBase.fromValue(
              enumNamesScalarVar[
                  kandid.util.CentralRandomizer.getInt(enumNamesScalarVar.length - 1)]);
      aGene.setScalarVar(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprScalarConstGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getScalarConst(), -1.0, 1.0, aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprScalarArgsListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen
      java.util.List list = aGene.getVarOrConstOrScalarExpression();
      // calculate new length of  list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 5, oldLength);
      // cut  list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        Object obj = iter.next();
        if (obj instanceof ExprScalarArgsListGene) {
          mutationCounter += mutate(env, (ExprScalarArgsListGene) obj, aChromosome, depth + 1);
        }
        if (obj instanceof ExprScalarArgsListGene) {
          mutationCounter += mutate(env, (ExprScalarArgsListGene) obj, aChromosome, depth + 1);
        }
        if (obj instanceof ExprScalarArgsListGene) {
          mutationCounter += mutate(env, (ExprScalarArgsListGene) obj, aChromosome, depth + 1);
        }
      }
      // append elements to  list
      int append = newLength - oldLength;
      while (append > 0) {
        switch (kandid.util.CentralRandomizer.getInt(1, 3)) {
          case 1:
            {
              /* 0 */
              // ExprScalarVarGene newGene = objectFactory.createExprScalarVarGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprScalarArgsListGene aNewVar = objectFactory.createExprScalarArgsListGene();
              randomize(aNewVar, aChromosome, depth + 1);
              list.add(aNewVar);
              break;
            }
          case 2:
            {
              /* 0 */
              // ExprScalarConstGene newGene = objectFactory.createExprScalarConstGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprScalarArgsListGene aNewConst =
                  objectFactory.createExprScalarArgsListGene();
              randomize(aNewConst, aChromosome, depth + 1);
              list.add(aNewConst);
              break;
            }
          case 3:
            {
              /* 0 */
              // ScalarExprGene newGene = objectFactory.createScalarExprGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprScalarArgsListGene aNewScalarExpression =
                  objectFactory.createExprScalarArgsListGene();
              randomize(aNewScalarExpression, aChromosome, depth + 1);
              list.add(aNewScalarExpression);
              break;
            }
        }
        --append;
      }
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprScalarListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getOpr(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getArgs(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ScalarExprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getList(), aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, ScalarExpressionChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getScalarExpression(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getNoiseSeed(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getXScale(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getYScale(), aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprVectorOprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesVectorOpr[] = {
      "add",
      "sub",
      "mult",
      "mod",
      "cross",
      "sincos",
      "atan",
      "maxvalue",
      "minvalue",
      "maxvector",
      "minvector",
      "maxmix",
      "invmix",
      "step",
      "noise",
      "turbulence",
      "waves",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      ExprVectorOprBase oldValue = aGene.getVectorOpr();
      ExprVectorOprBase newValue =
          ExprVectorOprBase.fromValue(
              enumNamesVectorOpr[
                  kandid.util.CentralRandomizer.getInt(enumNamesVectorOpr.length - 1)]);
      aGene.setVectorOpr(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprVectorVarGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesVectorVar[] = {
      "xyr", "xym", "xyt", "cmpow", "cmsinh", "cmim", "cmre",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      ExprVectorVarBase oldValue = aGene.getVectorVar();
      ExprVectorVarBase newValue =
          ExprVectorVarBase.fromValue(
              enumNamesVectorVar[
                  kandid.util.CentralRandomizer.getInt(enumNamesVectorVar.length - 1)]);
      aGene.setVectorVar(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprVectorConstGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getCx(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getCy(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getCz(), -1.0, 1.0, aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprVectorArgsListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen
      java.util.List list = aGene.getVarOrConstOrVectorExpression();
      // calculate new length of  list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 2, oldLength);
      // cut  list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        Object obj = iter.next();
        if (obj instanceof ExprVectorArgsListGene) {
          mutationCounter += mutate(env, (ExprVectorArgsListGene) obj, aChromosome, depth + 1);
        }
        if (obj instanceof ExprVectorArgsListGene) {
          mutationCounter += mutate(env, (ExprVectorArgsListGene) obj, aChromosome, depth + 1);
        }
        if (obj instanceof ExprVectorArgsListGene) {
          mutationCounter += mutate(env, (ExprVectorArgsListGene) obj, aChromosome, depth + 1);
        }
      }
      // append elements to  list
      int append = newLength - oldLength;
      while (append > 0) {
        switch (kandid.util.CentralRandomizer.getInt(1, 3)) {
          case 1:
            {
              /* 0 */
              // ExprVectorVarGene newGene = objectFactory.createExprVectorVarGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprVectorArgsListGene aNewVar = objectFactory.createExprVectorArgsListGene();
              randomize(aNewVar, aChromosome, depth + 1);
              list.add(aNewVar);
              break;
            }
          case 2:
            {
              /* 0 */
              // ExprVectorConstGene newGene = objectFactory.createExprVectorConstGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprVectorArgsListGene aNewConst =
                  objectFactory.createExprVectorArgsListGene();
              randomize(aNewConst, aChromosome, depth + 1);
              list.add(aNewConst);
              break;
            }
          case 3:
            {
              /* 0 */
              // VectorExprGene newGene = objectFactory.createVectorExprGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprVectorArgsListGene aNewVectorExpression =
                  objectFactory.createExprVectorArgsListGene();
              randomize(aNewVectorExpression, aChromosome, depth + 1);
              list.add(aNewVectorExpression);
              break;
            }
        }
        --append;
      }
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprVectorListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getOpr(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getArgs(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, VectorExprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getList(), aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, VectorExpressionChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getVectorExpression(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getNoiseSeed(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getXScale(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getYScale(), aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, AlphabetGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      String oldValue = new String(aGene.getValue());
      LsysGenetic.mutateAlphabet(aGene, (LsysChromosome) aChromosome);
      if (!aGene.getValue().equals(oldValue)) {
        ++mutationCounter;
      }
      // end section
    }
    return mutationCounter;
  }

  private int mutate(kandid.Environment env, AxiomGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      String oldValue = new String(aGene.getValue());
      LsysGenetic.mutateAxiom(aGene, (LsysChromosome) aChromosome);
      if (!aGene.getValue().equals(oldValue)) {
        ++mutationCounter;
      }
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, IgnoreGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      String oldValue = new String(aGene.getValue());
      LsysGenetic.mutateIgnore(aGene, (LsysChromosome) aChromosome);
      if (!aGene.getValue().equals(oldValue)) {
        ++mutationCounter;
      }
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PredecessorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      String oldValue = new String(aGene.getValue());
      LsysGenetic.mutatePredecessor(aGene, (LsysChromosome) aChromosome);
      if (!aGene.getValue().equals(oldValue)) {
        ++mutationCounter;
      }
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ContextGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      String oldValue = new String(aGene.getValue());
      LsysGenetic.mutateContext(aGene, (LsysChromosome) aChromosome);
      if (!aGene.getValue().equals(oldValue)) {
        ++mutationCounter;
      }
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, SuccessorGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      String oldValue = new String(aGene.getValue());
      LsysGenetic.mutateSuccessor(aGene, (LsysChromosome) aChromosome);
      if (!aGene.getValue().equals(oldValue)) {
        ++mutationCounter;
      }
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, LsysProductionGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getPredecessor(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSuccessor(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getLeftContext(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getRightContext(), aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, LsysChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getAlphabet(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getAxiom(), aChromosome, 1);
    {
      // mutate list for gen production
      java.util.List list = aChromosome.getProduction();
      // calculate new length of production list
      int oldLength = list.size();
      int newLength = LsysGenetic.getNumberOfProductions(aChromosome);
      // cut production list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (LsysProductionGene) iter.next(), aChromosome, 1);
      }
      // append elements to production list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ LsysProductionGene newGene = objectFactory.createLsysProductionGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    mutationCounter += mutate(env, aChromosome.getDirections(), 1, 36, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getBaseIndex(), 0, 256, aChromosome, 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, LsysD0LChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (LsysChromosome) aChromosome);
    mutationCounter += mutate(env, aChromosome.getDepth(), 1, 12, aChromosome, 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, Lsys0LChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (LsysChromosome) aChromosome);
    mutationCounter += mutate(env, aChromosome.getDepth(), 1, 12, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getJitter(), 0, 100, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getNoiseSeed(), aChromosome, 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, LsysILChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (LsysChromosome) aChromosome);
    mutationCounter += mutate(env, aChromosome.getIgnore(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getDepth(), 1, 12, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getJitter(), 0, 100, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getNoiseSeed(), aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, NormalizedVector3Gene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getX(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getY(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getZ(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, Matrix4X3Gene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getVal00(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal01(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal02(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal10(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal11(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal12(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal20(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal21(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal22(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal30(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal31(), -1.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getVal32(), -1.0, 1.0, aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovTurbulenceWarpGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getTurbulenceVector(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getOctaves(), 1, 6, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getOmega(), 0.01, 0.99, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getLambda(), 1.0, 2.5, aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovBlackHoleWarpGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getLocation(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getRadius(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getFalloff(), 0.1, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getStrength(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getInvers(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(kandid.Environment env, HsbftGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // call mutation for super class
    mutationCounter += mutate(env, (HsbColorGene) aGene, aChromosome, depth + 1);
    // mutate members
    mutationCounter += mutate(env, aGene.getFilter(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTransmit(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ColorMapEntryGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getHsbft(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovColorMapGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesMapPattern[] = {
      "boxed",
      "bozo",
      "bumps",
      "cells",
      "cylindrical",
      "dents",
      "granite",
      "leopard",
      "marble",
      "onion",
      "planar",
      "radial",
      "ripples",
      "spherical",
      "spotted",
      "waves",
      "wood",
      "wrinkles",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      PovMapPatternBase oldValue = aGene.getMapPattern();
      PovMapPatternBase newValue =
          PovMapPatternBase.fromValue(
              enumNamesMapPattern[
                  kandid.util.CentralRandomizer.getInt(enumNamesMapPattern.length - 1)]);
      aGene.setMapPattern(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    {
      // mutate list for gen color
      java.util.List list = aGene.getColor();
      // calculate new length of color list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 256, oldLength);
      // cut color list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (ColorMapEntryGene) iter.next(), aChromosome, 1);
      }
      // append elements to color list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ ColorMapEntryGene newGene = objectFactory.createColorMapEntryGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovTransformMapGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getMatrix(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getInvers(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovWarpGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getTurbulence(), aChromosome, depth + 1);
    {
      // mutate list for gen blackHole
      java.util.List list = aGene.getBlackHole();
      // calculate new length of blackHole list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 0, 10, oldLength);
      // cut blackHole list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (PovBlackHoleWarpGene) iter.next(), aChromosome, 1);
      }
      // append elements to blackHole list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ PovBlackHoleWarpGene newGene = objectFactory.createPovBlackHoleWarpGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovBlendGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesBlendMapModifier[] = {
      "ramp_wave", "triangle_wave", "sine_wave", "scallop_wave", "cubic_wave", "poly_wave",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      PovBlendMapModifierBase oldValue = aGene.getBlendMapModifier();
      PovBlendMapModifierBase newValue =
          PovBlendMapModifierBase.fromValue(
              enumNamesBlendMapModifier[
                  kandid.util.CentralRandomizer.getInt(enumNamesBlendMapModifier.length - 1)]);
      aGene.setBlendMapModifier(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    mutationCounter += mutate(env, aGene.getBlendMapFrequency(), 0.1, 10.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getBlendMapPhase(), 0.0, 1.0, aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovPigmentGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getColorMap(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getWarp(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTransform(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getBlend(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, NormalMapEntryGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getWeight(), aChromosome, depth + 1);
    String enumNamesMapPattern[] = {
      "boxed",
      "bozo",
      "bumps",
      "cells",
      "cylindrical",
      "dents",
      "granite",
      "leopard",
      "marble",
      "onion",
      "planar",
      "radial",
      "ripples",
      "spherical",
      "spotted",
      "waves",
      "wood",
      "wrinkles",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      PovMapPatternBase oldValue = aGene.getMapPattern();
      PovMapPatternBase newValue =
          PovMapPatternBase.fromValue(
              enumNamesMapPattern[
                  kandid.util.CentralRandomizer.getInt(enumNamesMapPattern.length - 1)]);
      aGene.setMapPattern(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    mutationCounter += mutate(env, aGene.getDepth(), 0.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getBumpSize(), 0.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getWarp(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTransform(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovNormalMapGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getAverage(), aChromosome, depth + 1);
    String enumNamesMapPattern[] = {
      "boxed",
      "bozo",
      "bumps",
      "cells",
      "cylindrical",
      "dents",
      "granite",
      "leopard",
      "marble",
      "onion",
      "planar",
      "radial",
      "ripples",
      "spherical",
      "spotted",
      "waves",
      "wood",
      "wrinkles",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      PovMapPatternBase oldValue = aGene.getMapPattern();
      PovMapPatternBase newValue =
          PovMapPatternBase.fromValue(
              enumNamesMapPattern[
                  kandid.util.CentralRandomizer.getInt(enumNamesMapPattern.length - 1)]);
      aGene.setMapPattern(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    {
      // mutate list for gen normal
      java.util.List list = aGene.getNormal();
      // calculate new length of normal list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 256, oldLength);
      // cut normal list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (NormalMapEntryGene) iter.next(), aChromosome, 1);
      }
      // append elements to normal list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ NormalMapEntryGene newGene = objectFactory.createNormalMapEntryGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovNormalGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getNormalMap(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getWarp(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTransform(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getBlend(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovReflectionGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getColor(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getMetallic(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovFinishGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getAmbient(), 0.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getDiffuse(), 0.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSpecular(), 0.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getRoughness(), 0.001, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getMetallic(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getReflection(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovTextureLayerGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getPigment(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovThingGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, PovThingChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getThing(), aChromosome, 1);
    {
      // mutate list for gen textureLayer
      java.util.List list = aChromosome.getTextureLayer();
      // calculate new length of textureLayer list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 20, oldLength);
      // cut textureLayer list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (PovTextureLayerGene) iter.next(), aChromosome, 1);
      }
      // append elements to textureLayer list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ PovTextureLayerGene newGene = objectFactory.createPovTextureLayerGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, PovThingNFChromosome aChromosome) throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (PovThingChromosome) aChromosome);
    mutationCounter += mutate(env, aChromosome.getNormal(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getFinish(), aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprSdlOprGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesSdlOpr[] = {
      "add", "mult", "sub", "div", "max", "min", "mod", "noise", "snoise", "atanq", "pow", "sqrt",
      "pow", "abs", "acos", "acosh", "asin", "asinh", "atan", "atanh", "ceil", "cos", "cosh",
      "degrees", "exp", "floor", "ln", "log", "radians", "sin", "sinh", "sqrt", "tan", "tanh",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      ExprSdlOprBase oldValue = aGene.getSdlOpr();
      ExprSdlOprBase newValue =
          ExprSdlOprBase.fromValue(
              enumNamesSdlOpr[kandid.util.CentralRandomizer.getInt(enumNamesSdlOpr.length - 1)]);
      aGene.setSdlOpr(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprSdlVarGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    String enumNamesSdlVar[] = {
      "x", "y", "z",
    };
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      // section copied from xsd:annotation/xsd:appinfo/kandid:mutation
      ExprSdlVarBase oldValue = aGene.getSdlVar();
      ExprSdlVarBase newValue =
          ExprSdlVarBase.fromValue(
              enumNamesSdlVar[kandid.util.CentralRandomizer.getInt(enumNamesSdlVar.length - 1)]);
      aGene.setSdlVar(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
      // end section
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprSdlConstGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getSdlConst(), -1.0, 1.0, aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprSdlArgsListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen
      java.util.List list = aGene.getVarOrConstOrSdlExpression();
      // calculate new length of  list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 5, oldLength);
      // cut  list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        Object obj = iter.next();
        if (obj instanceof ExprSdlArgsListGene) {
          mutationCounter += mutate(env, (ExprSdlArgsListGene) obj, aChromosome, depth + 1);
        }
        if (obj instanceof ExprSdlArgsListGene) {
          mutationCounter += mutate(env, (ExprSdlArgsListGene) obj, aChromosome, depth + 1);
        }
        if (obj instanceof ExprSdlArgsListGene) {
          mutationCounter += mutate(env, (ExprSdlArgsListGene) obj, aChromosome, depth + 1);
        }
      }
      // append elements to  list
      int append = newLength - oldLength;
      while (append > 0) {
        switch (kandid.util.CentralRandomizer.getInt(1, 3)) {
          case 1:
            {
              /* 0 */
              // ExprSdlVarGene newGene = objectFactory.createExprSdlVarGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprSdlArgsListGene aNewVar = objectFactory.createExprSdlArgsListGene();
              randomize(aNewVar, aChromosome, depth + 1);
              list.add(aNewVar);
              break;
            }
          case 2:
            {
              /* 0 */
              // ExprSdlConstGene newGene = objectFactory.createExprSdlConstGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprSdlArgsListGene aNewConst = objectFactory.createExprSdlArgsListGene();
              randomize(aNewConst, aChromosome, depth + 1);
              list.add(aNewConst);
              break;
            }
          case 3:
            {
              /* 0 */
              // SdlExpressionGene newGene = objectFactory.createSdlExpressionGene();
              // randomize(newGene, aChromosome);
              // list.add(newGene);
              /* 1 */ ExprSdlArgsListGene aNewSdlExpression =
                  objectFactory.createExprSdlArgsListGene();
              randomize(aNewSdlExpression, aChromosome, depth + 1);
              list.add(aNewSdlExpression);
              break;
            }
        }
        --append;
      }
    }
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, ExprSdlListGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getOpr(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getArgs(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, SdlExpressionGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getList(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, PovRotateGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getRx(), -180.0, 180.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getRy(), -180.0, 180.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getRz(), -180.0, 180.0, aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env,
      PovRidgedMultifractalGene aGene,
      ChromosomeType aChromosome,
      int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getFx(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getFy(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getFz(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getH(), 0.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getLacunarity(), 1.0, 100.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getOctaves(), 1, 6, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getOffset(), 0.0, 1.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getGain(), 0.0, 1.0, aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, PovIsoSurfaceChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (PovThingNFChromosome) aChromosome);
    mutationCounter += mutate(env, aChromosome.getRidgedMultifractal(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getThreshold(), aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getRotate(), aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env,
      AbstractTutorialShapeGene aGene,
      ChromosomeType aChromosome,
      int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getColor(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getTransparency(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getX(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getY(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, TutorialCircleGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // call mutation for super class
    mutationCounter += mutate(env, (AbstractTutorialShapeGene) aGene, aChromosome, depth + 1);
    // mutate members
    mutationCounter += mutate(env, aGene.getRadius(), aChromosome, depth + 1);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, TutorialShapeChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    {
      // mutate list for gen allShapes
      java.util.List list = aChromosome.getAllShapes();
      // calculate new length of allShapes list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 2, 100, oldLength);
      // cut allShapes list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (TutorialCircleGene) iter.next(), aChromosome, 1);
      }
      // append elements to allShapes list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ TutorialCircleGene newGene = objectFactory.createTutorialCircleGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    mutationCounter += mutate(env, aChromosome.getColor(), aChromosome, 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, WarpingTurbulenceGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    mutationCounter += mutate(env, aGene.getTimeCoord(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getOctaves(), 0.0, 7.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getAmpscale(), 0.2, 0.8, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getFreqscale(), 1.0, 4.0, aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getScaleOut(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getScaleXin(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getScaleYin(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSource1(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSource2(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSource3(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSource4(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSeed1(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSeed2(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSeed3(), aChromosome, depth + 1);
    mutationCounter += mutate(env, aGene.getSeed4(), aChromosome, depth + 1);
    return mutationCounter;
  }

  private int mutate(
      kandid.Environment env, WarpingLayerGene aGene, ChromosomeType aChromosome, int depth)
      throws JAXBException {
    int mutationCounter = 0;
    // mutate members
    {
      // mutate list for gen term
      java.util.List list = aGene.getTerm();
      // calculate new length of term list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 1, 2, oldLength);
      // cut term list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (WarpingTurbulenceGene) iter.next(), aChromosome, 1);
      }
      // append elements to term list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ WarpingTurbulenceGene newGene = objectFactory.createWarpingTurbulenceGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, DomainWarpingChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, aChromosome.getMainscale(), 0.1, 10.0, aChromosome, 1);
    mutationCounter += mutate(env, aChromosome.getGradientgain(), 0.001, 0.999, aChromosome, 1);
    {
      // mutate list for gen warpingLayer
      java.util.List list = aChromosome.getWarpingLayer();
      // calculate new length of warpingLayer list
      int oldLength = list.size();
      int newLength = mutateListLength(env, 1, 5, oldLength);
      // cut warpingLayer list
      cutList(newLength, list);
      // mutate remaining elements
      java.util.Iterator iter = list.iterator();
      while (iter.hasNext()) {
        mutationCounter += mutate(env, (WarpingLayerGene) iter.next(), aChromosome, 1);
      }
      // append elements to warpingLayer list
      int append = newLength - oldLength;
      while (append > 0) {
        /* 2 */ WarpingLayerGene newGene = objectFactory.createWarpingLayerGene();
        randomize(newGene, aChromosome, 0);
        list.add(newGene);
        --append;
      }
      mutationCounter +=
          (newLength > oldLength) ? (newLength - oldLength) : (oldLength - newLength);
      mutationCounter += scrambleList(env, list);
    }
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, DomainWarpingChladniNoiseChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (DomainWarpingChromosome) aChromosome);
    return mutationCounter;
  }

  public int mutate(kandid.Environment env, DomainWarpingChladniWorleyNoiseChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (DomainWarpingChromosome) aChromosome);
    return mutationCounter;
  }

  public int mutate(
      kandid.Environment env, DomainWarpingChladniWorleyPerlinNoiseChromosome aChromosome)
      throws JAXBException {
    int mutationCounter = 0;
    mutationCounter += mutate(env, (DomainWarpingChromosome) aChromosome);
    return mutationCounter;
  }
}
