package kandid.soup.genetic.vectorvm;

import java.util.List;

import kandid.Environment;
import kandid.soup.ExprVectorArgsListGene;
import kandid.soup.ExprVectorConstGene;
import kandid.soup.ExprVectorListGene;
import kandid.soup.ExprVectorOprBase;
import kandid.soup.ExprVectorOprGene;
import kandid.soup.ExprVectorVarGene;
import kandid.soup.GeneType;
import kandid.soup.ObjectFactory;
import kandid.soup.VectorExprGene;
import kandid.soup.VectorExpressionChromosome;
import kandid.soup.SeedGene;
import kandid.soup.SymmetricGene;

public class Merger {
  private static ObjectFactory objectFactory = new ObjectFactory();

  public static VectorExpressionChromosome merge(Environment env, VectorExpressionChromosome chromosome1, VectorExpressionChromosome chromosome2) {
    VectorExpressionChromosome new_chromosome = objectFactory.createVectorExpressionChromosome();
    new_chromosome.setNoiseSeed(merge(env, chromosome1.getNoiseSeed(), chromosome2.getNoiseSeed()));
    new_chromosome.setXScale(merge(env, chromosome1.getXScale(), chromosome2.getXScale()));
    new_chromosome.setYScale(merge(env, chromosome1.getYScale(), chromosome2.getYScale()));
    new_chromosome.setVectorExpression(merge(env, chromosome1.getVectorExpression(), chromosome2.getVectorExpression()));
    return new_chromosome;
  }

  private static SymmetricGene merge(Environment env, SymmetricGene gene1, SymmetricGene gene2) {
    SymmetricGene new_symmetric_gene = objectFactory.createSymmetricGene();
    double value = env.isSource1() ? gene1.getValue() : gene2.getValue();
    new_symmetric_gene.setValue(value);
    return new_symmetric_gene;
  }

  private static SeedGene merge(Environment env, SeedGene gene1, SeedGene gene2) {
    SeedGene new_noiseSeed = objectFactory.createSeedGene();
    long seed = env.isSource1() ? gene1.getValue().longValue() : gene2.getValue().longValue();
    new_noiseSeed.setValue(Long.valueOf(seed));
    return new_noiseSeed;
  }

  private static VectorExprGene merge(Environment env, VectorExprGene gene1, VectorExprGene gene2) {
    VectorExprGene new_scalarExpression = objectFactory.createVectorExprGene();
    ExprVectorListGene scalarList1 = gene1.getList();
    ExprVectorListGene scalarList2 = gene2.getList();
    
    ExprVectorListGene new_list = objectFactory.createExprVectorListGene();
    new_scalarExpression.setList(new_list);

    ExprVectorOprGene new_opr = objectFactory.createExprVectorOprGene();
    ExprVectorOprGene opr1or2 = env.isSource1() ? scalarList1.getOpr() : scalarList2.getOpr();
    String opr_value = opr1or2.getVectorOpr().value();
    new_opr.setVectorOpr(ExprVectorOprBase.fromValue(opr_value));
    new_list.setOpr(new_opr);

    ExprVectorArgsListGene new_args = objectFactory.createExprVectorArgsListGene();
    new_list.setArgs(new_args);
    
    List<GeneType> vce1_list = scalarList1.getArgs().getVarOrConstOrVectorExpression();
    List<GeneType> vce2_list = scalarList2.getArgs().getVarOrConstOrVectorExpression();
    int length1 = vce1_list.size();
    int length2 = vce2_list.size();
    int commonLength = length1 < length2 ? length1 : length2;
    for(int ci=0; ci<commonLength; ++ci) {
//    * {@link ExprVectorVarGene }
//    * {@link ExprVectorConstGene }
//    * {@link VectorExprGene }
      GeneType vce1 = vce1_list.get(ci);
      GeneType vce2 = vce2_list.get(ci);
      if(vce1 instanceof ExprVectorVarGene && vce2 instanceof ExprVectorVarGene) {
        ExprVectorVarGene vce1or2_var_gene = env.isSource1() ? (ExprVectorVarGene)vce1 : (ExprVectorVarGene)vce2;
        Cloner.add_var_gene(new_args, vce1or2_var_gene);
      }
      else if(vce1 instanceof ExprVectorConstGene && vce2 instanceof ExprVectorConstGene) {
        ExprVectorConstGene vce1or2_const_gene = env.isSource1() ? (ExprVectorConstGene)vce1 : (ExprVectorConstGene)vce2;
        Cloner.add_const_gene(new_args, vce1or2_const_gene);
      }
      else if(vce1 instanceof VectorExprGene && vce2 instanceof VectorExprGene) {
        VectorExprGene new_expr_gene;
        if(env.isSource1()) {
          new_expr_gene = merge(env, ((VectorExprGene)vce1), ((VectorExprGene)vce2));
        }
        else {
          new_expr_gene = merge(env, ((VectorExprGene)vce2), ((VectorExprGene)vce1));
        }
        new_args.getVarOrConstOrVectorExpression().add(new_expr_gene);
      }
      else if(vce1 instanceof ExprVectorVarGene && vce2 instanceof ExprVectorConstGene) {
        if(env.isSource1()) {
          Cloner.add_var_gene(new_args, (ExprVectorVarGene)vce1);
        }
        else {
          Cloner.add_const_gene(new_args, (ExprVectorConstGene)vce2);
        }
      }
      else if(vce1 instanceof ExprVectorConstGene && vce2 instanceof ExprVectorVarGene) {
        if(env.isSource1()) {
          Cloner.add_const_gene(new_args, (ExprVectorConstGene)vce1);
        }
        else {
          Cloner.add_var_gene(new_args, (ExprVectorVarGene)vce2);
        }
      }
      else if(vce1 instanceof VectorExprGene && vce2 instanceof ExprVectorVarGene) {
        if(env.isSource1()) {
          VectorExprGene new_expr_gene = Cloner.deepclone((VectorExprGene)vce1);
          new_args.getVarOrConstOrVectorExpression().add(new_expr_gene);
        }
        else {
          Cloner.add_var_gene(new_args, (ExprVectorVarGene)vce2);
        }
      }
      else if(vce1 instanceof VectorExprGene && vce2 instanceof ExprVectorConstGene) {
        if(env.isSource1()) {
          VectorExprGene new_expr_gene = Cloner.deepclone((VectorExprGene)vce1);
          new_args.getVarOrConstOrVectorExpression().add(new_expr_gene);
        }
        else {
          Cloner.add_const_gene(new_args, (ExprVectorConstGene)vce2);
        }
      }
      else if(vce1 instanceof ExprVectorVarGene && vce2 instanceof VectorExprGene) {
        if(env.isSource1()) {
          Cloner.add_var_gene(new_args, (ExprVectorVarGene)vce1);
        }
        else {
          VectorExprGene new_expr_gene = Cloner.deepclone((VectorExprGene)vce2);
          new_args.getVarOrConstOrVectorExpression().add(new_expr_gene);
        }
      }
      else if(vce1 instanceof ExprVectorConstGene && vce2 instanceof VectorExprGene) {
        if(env.isSource1()) {
          Cloner.add_const_gene(new_args, (ExprVectorConstGene)vce1);
        }
        else {
          VectorExprGene new_expr_gene = Cloner.deepclone((VectorExprGene)vce2);
          new_args.getVarOrConstOrVectorExpression().add(new_expr_gene);
        }
      }
      else {
        assert false : "no strategy for merging " + vce1.getClass().getName() + " with " + vce2.getClass().getName();
      }
    }
    return new_scalarExpression;
  }
}
