package kandid.soup.genetic.scalarvm;

import java.util.List;

import kandid.soup.DoubleGene;
import kandid.soup.ExprScalarArgsListGene;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarOprGene;
import kandid.soup.ExprScalarVarBase;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.GeneType;
import kandid.soup.ObjectFactory;
import kandid.soup.ScalarExprGene;
import kandid.soup.ScalarExpressionChromosome;
import kandid.soup.SeedGene;
import kandid.soup.SymmetricGene;

public class Cloner {
  private static ObjectFactory objectFactory = new ObjectFactory();

  public static ScalarExpressionChromosome deepclone(ScalarExpressionChromosome chromosome1) {
//    System.out.println("deepclone chromosome1 " + chromosome1.getClass().getSimpleName() + " " + chromosome1);
    ScalarExpressionChromosome new_chromosome = objectFactory.createScalarExpressionChromosome();
    new_chromosome.setNoiseSeed(deepclone(chromosome1.getNoiseSeed()));
    new_chromosome.setXScale(deepclone(chromosome1.getXScale()));
    new_chromosome.setYScale(deepclone(chromosome1.getYScale()));
    new_chromosome.setScalarExpression(deepclone(chromosome1.getScalarExpression()));
    return new_chromosome;
  }

  private static SymmetricGene deepclone(SymmetricGene gene1) {
    SymmetricGene new_symmetric_gene = objectFactory.createSymmetricGene();
    double value = gene1.getValue();
    new_symmetric_gene.setValue(Double.valueOf(value));
    return new_symmetric_gene;
  }

  private static SeedGene deepclone(SeedGene gene1) {
    SeedGene new_noiseSeed = objectFactory.createSeedGene();
    long seed = gene1.getValue().longValue();
    new_noiseSeed.setValue(Long.valueOf(seed));
    return new_noiseSeed;
  }

  public static ScalarExprGene deepclone(ScalarExprGene gene1) {
    ScalarExprGene new_scalarExpression = objectFactory.createScalarExprGene();
    ExprScalarListGene scalarList1 = gene1.getList();
    
    ExprScalarListGene new_list = objectFactory.createExprScalarListGene();
    new_scalarExpression.setList(new_list);

    ExprScalarOprGene new_opr = objectFactory.createExprScalarOprGene();
    ExprScalarOprGene opr1 = scalarList1.getOpr();
    String opr_value = opr1.getScalarOpr().value();
    new_opr.setScalarOpr(ExprScalarOprBase.fromValue(opr_value));
    new_list.setOpr(new_opr);

    ExprScalarArgsListGene new_args = objectFactory.createExprScalarArgsListGene();
    new_list.setArgs(new_args);
    
    List<GeneType> vce1_list = scalarList1.getArgs().getVarOrConstOrScalarExpression();
    int length1 = vce1_list.size();
    for(int ci=0; ci<length1; ++ci) {
//    * {@link ExprScalarVarGene }
//    * {@link ExprScalarConstGene }
//    * {@link ScalarExprGene }
      GeneType vce1 = vce1_list.get(ci);
      if(vce1 instanceof ExprScalarVarGene) {
        ExprScalarVarGene vce1_var_gene = (ExprScalarVarGene)vce1;
        add_var_gene(new_args, vce1_var_gene);
      }
      else if(vce1 instanceof ExprScalarConstGene) {
        ExprScalarConstGene vce1_const_gene = (ExprScalarConstGene)vce1;
        add_const_gene(new_args, vce1_const_gene);
      }
      else if(vce1 instanceof ScalarExprGene) {
        ScalarExprGene new_expr_gene = deepclone(((ScalarExprGene)vce1));
        new_args.getVarOrConstOrScalarExpression().add(new_expr_gene);
      }
      else {
        assert false : "no strategy for cloning " + vce1.getClass().getName();
      }
    }
    return new_scalarExpression;
  }

  public static void add_const_gene(ExprScalarArgsListGene new_args, ExprScalarConstGene vce1_const_gene) {
    ExprScalarConstGene new_cnst_gene = objectFactory.createExprScalarConstGene();
    DoubleGene new_dbl_cnst = objectFactory.createDoubleGene();
    double value = vce1_const_gene.getScalarConst().getValue();
    new_dbl_cnst.setValue(Double.valueOf(value));
    new_cnst_gene.setScalarConst(new_dbl_cnst);
    new_args.getVarOrConstOrScalarExpression().add(new_cnst_gene);
  }

  public static void add_var_gene(ExprScalarArgsListGene new_args, ExprScalarVarGene vce1_var_gene) {
    ExprScalarVarGene new_var_gene = objectFactory.createExprScalarVarGene();
    String value = vce1_var_gene.getScalarVar().value();
    new_var_gene.setScalarVar(ExprScalarVarBase.fromValue(value));
    new_args.getVarOrConstOrScalarExpression().add(new_var_gene);
  }

}
