/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.genetic.lsys;

import kandid.soup.ContextGene;
import kandid.soup.IgnoreGene;
import kandid.soup.LsysChromosome;
import kandid.util.CentralRandomizer;

/**
 * @author thomas jourdan
 *
 */
public class LsysILGeneticWorker extends Lsys0LGeneticWorker {

  /**
   * @param lsysChromosome
   * @return
   */
  public String randomizeContext(LsysChromosome lsysChromosome) {
    if(CentralRandomizer.getBoolean())
      return super.randomizePredecessor(lsysChromosome);
    else
      return "";
  }

  /**
   * @param lsysChromosome
   * @return
   */
  public String randomizeIgnore(LsysChromosome lsysChromosome) {
    String ignore = "";
    String alphabeth = lsysChromosome.getAlphabet().getValue();
    for (int ax = 0; ax < alphabeth.length(); ax++) {
      if(CentralRandomizer.getBoolean()) {
        ignore += alphabeth.charAt(ax);
      }
    }
    return ignore;
  }

  /**
   * @param aGene
   * @param lsysChromosome
   */
  public void mutateContext(ContextGene aGene, LsysChromosome lsysChromosome) {
    if(CentralRandomizer.getBoolean()) {
      String alphabeth = lsysChromosome.getAlphabet().getValue();
      char[] chars = aGene.getValue().toCharArray();
      if(chars.length == 1) {    
        chars[0] = alphabeth.charAt(kandid.util.CentralRandomizer.getInt(0, alphabeth.length() - 1));
        aGene.setValue(new String(chars));
      }
      else {
        aGene.setValue(super.randomizePredecessor(lsysChromosome));
      }
    }
    else {
      aGene.setValue("");
    }
  }

  /**
   * @param aGene
   * @param lsysChromosome
   */
  public void mutateIgnore(IgnoreGene aGene, LsysChromosome lsysChromosome) {
    // TODO Ignore character are not mutated.
  }

}
