/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.genetic.lsys;

import kandid.soup.AlphabetGene;
import kandid.soup.AxiomGene;
import kandid.soup.ContextGene;
import kandid.soup.IgnoreGene;
import kandid.soup.LsysChromosome;
import kandid.soup.PredecessorGene;
import kandid.soup.SuccessorGene;

public class LsysGenetic {

  /**
   * @param lsysChromosome
   * @return
   */
  public static String randomizeAlphabet(LsysChromosome lsysChromosome) {
    String alphabeth = LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).randomizeAlphabet(lsysChromosome);
    return alphabeth;
  }

  /**
   * @param lsysChromosome
   * @return
   */
  public static String randomizeAxiom(LsysChromosome lsysChromosome) {
    String characters= LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).randomizeAxiom(lsysChromosome);
    return characters;
  }

  /**
   * @param lsysChromosome
   * @return
   */
  public static String randomizePredecessor(LsysChromosome lsysChromosome) {
    String characters= LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).randomizePredecessor(lsysChromosome);
    return characters;
  }

  /**
   * @param chromosome
   * @return
   */
  public static String randomizeContext(LsysChromosome lsysChromosome) {
    String characters= LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).randomizeContext(lsysChromosome);
    return characters;
  }

  /**
   * @param lsysChromosome
   * @return
   */
  public static String randomizeSuccessor(LsysChromosome lsysChromosome) {
    String characters = LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).randomizeSuccessor(lsysChromosome);
    return characters;
  }

  /**
   * @param chromosome
   * @return
   */
  public static String randomizeIgnore(LsysChromosome lsysChromosome) {
    String characters = LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).randomizeIgnore(lsysChromosome);
    return characters;
  }

//!!  public static String randomizeProduction(LsysChromosome lsysChromosome) {
//!!  }
  
  
  /**
   * @param characters
   * @param lsysChromosome
   */
  public static void mutateAlphabet(AlphabetGene aGene, LsysChromosome lsysChromosome) {
    LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).mutateAlphabet(aGene, lsysChromosome);
  }

  /**
   * @param characters
   * @param lsysChromosome
   */
  public static void mutateAxiom(AxiomGene aGene, LsysChromosome lsysChromosome) {
    LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).mutateAxiom(aGene, lsysChromosome);
  }

  /**
   * @param characters
   * @param lsysChromosome
   */
  public static void mutatePredecessor(PredecessorGene aGene, LsysChromosome lsysChromosome) {
    LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).mutatePredecessor(aGene, lsysChromosome);
  }

  /**
   * @param aGene
   * @param chromosome
   */
  public static void mutateContext(ContextGene aGene, LsysChromosome lsysChromosome) {
    LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).mutateContext(aGene, lsysChromosome);
  }

  /**
   * @param characters
   * @param lsysChromosome
   */
  public static void mutateSuccessor(SuccessorGene aGene, LsysChromosome lsysChromosome) {
    LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).mutateSuccessor(aGene, lsysChromosome);
  }

  /**
   * @param chromosome
   * @return
   */
  public static void mutateIgnore(IgnoreGene aGene, LsysChromosome lsysChromosome) {
    LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).mutateIgnore(aGene, lsysChromosome);
  }

  /**
   * Calculates the number of productions.
   * In an D0L System the number of productions can never be greater than the number of characters in the alphabet.
   * A non deterministic 0L has no limit in number of productions.
   * @param lsysChromosome
   * @return number of productions
   */
  public static int getNumberOfProductions(LsysChromosome lsysChromosome) {
    return LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).getNumberOfProductions( lsysChromosome);
  }

//!!  public static void mutateProduction(LsysProductionGene aGene, LsysChromosome lsysChromosome) {
//!!    LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).mutateProduction(aGene, lsysChromosome);
//!!  }

  /**
   * For a D0L system all predecessors must be uniqe.
   * @param chromosome
   * @return true if an LsysChromosome is inconsitent.
   */
  public static boolean reject(LsysChromosome lsysChromosome) {
    return LsysGeneticFactory.getLsysGeneticWorker(lsysChromosome).reject( lsysChromosome);
  }

}
