/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.genetic.lsys;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

import kandid.soup.LsysChromosome;
import kandid.soup.LsysProductionGene;
import kandid.util.CentralRandomizer;
import kandid.util.Debug;

/**
 * @author thomas jourdan
 *
 */
public class LsysD0LGeneticWorker extends LsysGeneticWorker {

  /**
   * @param lsysChromosome
   * @return
   */
  public String randomizeAlphabet(LsysChromosome lsysChromosome) {
    List alphabethList = super.randomizeAlphabetList(lsysChromosome);
    String alphabeth = "";
    Random rand = new Random(CentralRandomizer.getLong());
    Collections.shuffle(alphabethList, rand);
    for (Iterator iter = alphabethList.iterator(); iter.hasNext();) {
      String character = (String) iter.next();
      alphabeth += character.charAt(0);
    }
    return alphabeth;
  }

  /**
   * @param lsysChromosome
   * @return
   */
  public String randomizePredecessor(LsysChromosome lsysChromosome) {
    String alphabeth = lsysChromosome.getAlphabet().getValue();
    int pos = lsysChromosome.getProduction().size();
    StringBuffer characters = new StringBuffer();
    if(Debug.enabled) assert pos < alphabeth.length();
    characters.append(alphabeth.charAt(pos));
    return characters.toString();
  }

  /* (non-Javadoc)
   * @see kandid.soup.genetic.lsys.LsysGeneticWorker#getMaxProductions(kandid.soup.impl.LsysChromosomeImpl)
   */
  public int getNumberOfProductions(LsysChromosome lsysChromosome) {
    return 1+CentralRandomizer.getBinomial(lsysChromosome.getAlphabet().getValue().length()-1, 0.5);
  }

  /**
   * @param lsysChromosome
   * @return
   */
  public boolean reject(LsysChromosome lsysChromosome) {
    List productionList = lsysChromosome.getProduction();
    int ix1 = 0;
    for (Iterator iter1 = productionList.iterator(); iter1.hasNext();) {
      LsysProductionGene production1 = (LsysProductionGene) iter1.next();
      int ix2 = 0;
      for (Iterator iter2 = productionList.iterator(); iter2.hasNext();) {
        LsysProductionGene production2 = (LsysProductionGene) iter2.next();
        if(ix1 != ix2 && production1.getPredecessor().getValue().equals(production2.getPredecessor().getValue())) {
          return true;
        }
        ++ix2;
      }
      ++ix1;
    }
    return false;
  }

}
