/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.preference.test;

import junit.framework.TestCase;
import kandid.preference.PreferenceType;
import kandid.preference.util.PreferenceModel;
import kandid.util.Debug;

/**
 * @author thomas jourdan
 *
 */
public class PreferenceTest extends TestCase {

  /**
   * Constructor for PreferenceTest.
   * @param arg0
   */
  public PreferenceTest(String arg0) {
    super(arg0);
  }

  public void testPreference() {
    try {
      PreferenceType preferences = PreferenceModel.getInstance().getPreference();
      assertEquals("http://", preferences.getKandid().getHome());
      assertEquals("", preferences.getUser().getNickname());
      assertFalse(preferences.getHttpProxy().isEnabled());
      assertEquals("", preferences.getHttpProxy().getHost());
      assertEquals(80, preferences.getHttpProxy().getPort());
      assertEquals("", preferences.getHttpProxy().getNonProxyHosts());
      assertEquals("", preferences.getHttpProxy().getUsername());
      assertEquals("****", preferences.getHttpProxy().getPassword());
    }
    catch (Exception exc) {
      Debug.stackTrace(exc);
      assertTrue(false);
    }
  }

}
