/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.pond.util;

public class ConnectingDialog extends javax.swing.JFrame {
  private static final long serialVersionUID = 1L;
  
  private boolean stoped;
  private Thread thread;

  /** Creates new form ConnectingDialog */
  public ConnectingDialog(java.awt.Frame parent, boolean modal, Thread thread) {
    super();
    this.thread = thread;
    stoped = false;
    initComponents();
    if (parent != null) {
      setLocationRelativeTo(parent);
    }
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  private void initComponents() { //GEN-BEGIN:initComponents
    waitLabel = new javax.swing.JLabel();
    stopButton = new javax.swing.JButton();

    getContentPane().setLayout(new java.awt.GridLayout(2, 1));

    setTitle("Search for breeder");
    //!!    setName("BreederListConnectingDialog");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        closeDialog(evt);
      }
    });

    waitLabel.setText("Connecting");
    getContentPane().add(waitLabel);

    stopButton.setText("Stop");
    stopButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        stopButtonActionPerformed(evt);
      }
    });

    getContentPane().add(stopButton);

    pack();
  } //GEN-END:initComponents

  private void stopButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_stopButtonActionPerformed
    stoped = true;
    thread.interrupt();
    closeDialog(null);
  } //GEN-LAST:event_stopButtonActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) { //GEN-FIRST:event_closeDialog
    setVisible(false);
    dispose();
  } //GEN-LAST:event_closeDialog

  /**
   * Returns the stoped flag
   * @return boolean
   */
  public boolean isStoped() {
    return stoped;
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel waitLabel;
  private javax.swing.JButton stopButton;
  // End of variables declaration//GEN-END:variables

}
