/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.pond.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

import kandid.pond.BreederType;
import kandid.pond.PondType;

/**
 * 
 * @author thomas jourdan
 */
public class BreederListConnection {

  String randomBreederURL;
  PondType pond;

  /**
   * Constructor for BreederListConnection.
   */
  public BreederListConnection() {
  }

  /**
   * Returns the input stream of a HTTP connection.
   * @return InputStream
   * @throws IOException
   * @throws URISyntaxException 
   */
  private InputStream getInputStream() throws IOException, URISyntaxException {
    InputStream in = null;
    URL url = new URI(randomBreederURL).toURL();
    HttpURLConnection httpConnection = (HttpURLConnection) url.openConnection();
    int resp = httpConnection.getResponseCode();
    if (resp == 200) {
      in = httpConnection.getInputStream();
    }
    return in;
  }

  /**
   * Read pond data from URL. Only HTTP connection is suported.
   * @param randomBreederURL
   * @throws JAXBException
   * @throws IOException
   * @throws URISyntaxException 
   */
  public void readPond(String randomBreederURL) throws JAXBException, IOException, URISyntaxException {
    this.randomBreederURL = randomBreederURL;
    JAXBContext jc = JAXBContext.newInstance("kandid.pond");
    Unmarshaller u = jc.createUnmarshaller();
    if(kandid.util.Debug.enabled) {
      StringBuffer randomBreeder = new StringBuffer();
      InputStream in = getInputStream();
      if (in != null) {
        int chr = in.read();
        while (chr > 0) {
          randomBreeder.append((char)chr);
          chr = in.read();
        }
        in.close();
      }
      String stringRepresentation = randomBreeder.toString();
      stringRepresentation = stringRepresentation.trim();
      System.out.println(randomBreederURL);
      System.out.println("[" + stringRepresentation + "]");
      pond = (kandid.pond.PondType) u.unmarshal(new StreamSource(new StringReader(stringRepresentation)));
    }
    else {
      pond = (kandid.pond.PondType) u.unmarshal(getInputStream());
    }

  }

  /**
   * Returns the randomly selected breeder..
   * @return BreederType
   */
  public BreederType getRandomBreeder() {
    BreederType breederType = null;
    List breederList = pond.getBreeder();
    if (breederList != null && breederList.size() > 0) {
      breederType = (BreederType) breederList.get(0);
    }
    return breederType;
  }

}
