/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.pond.ui;

import java.awt.FlowLayout;
import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;

import kandid.Kandid;
import kandid.util.Debug;

/**
 * @author thomas jourdan
 *
 */
public class UiPool extends JFrame {
	private static final long serialVersionUID = 1L;

  private javax.swing.JPanel poolContentPane = null;

	private JPanel typePanel = null;
	private JPanel navigationPanel = null;
	private JPanel loadPanel = null;
	private JButton firstButton = null;
	private JButton leftButton = null;
	private JButton rightButton = null;
	private JButton lastButton = null;
	private JButton loadButton = null;
	private JScrollPane typeScrollPane = null;
	private JTree typeTree = null;
	private JPanel poolPanel = null;
	private JPanel selectionPanel = null;
	private JRadioButton bothRadioButton = null;
	private JRadioButton loadedRadioButton = null;
	private JRadioButton ownRadioButton = null;
	private JLabel jLabel = null;

  private ButtonGroup viewGroup = new ButtonGroup();
  private IlPool ilPool;
	private JPanel viewPanel = null;
	private JButton configureButton = null;
  private static ImageIcon firstImageIcon;
  private static ImageIcon leftImageIcon;
  private static ImageIcon rightImageIcon;
  private static ImageIcon lastImageIcon;
  private static ImageIcon loadImageIcon;
  private static ImageIcon configureImageIcon;

    /**
	 * This is the default constructor
	 */
	public UiPool() {
		super();
    try {
      if (firstImageIcon == null)
        firstImageIcon = Kandid.getInstance().createImageIcon("first.png", null);
      if (leftImageIcon == null)
        leftImageIcon = Kandid.getInstance().createImageIcon("left.png", null);
      if (rightImageIcon == null)
        rightImageIcon = Kandid.getInstance().createImageIcon("right.png", null);
      if (lastImageIcon == null)
        lastImageIcon = Kandid.getInstance().createImageIcon("last.png", null);
      if (loadImageIcon == null)
        loadImageIcon = Kandid.getInstance().createImageIcon("readdb.png", null);
      if (configureImageIcon == null)
        configureImageIcon = Kandid.getInstance().createImageIcon("preferences.png", null);
    } catch (Exception exc) {
      Debug.stackTrace(exc);
    }
		initialize();
    viewGroup.add(bothRadioButton);
    viewGroup.add(loadedRadioButton);
    viewGroup.add(ownRadioButton);
	}
	/**
   * @param ilPool
   */
  public UiPool(IlPool pool) {
    this();
    this.ilPool = pool;
  }
  /**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setContentPane(getPoolContentPane());
		//this.setBounds(0, 0, 300, 670);
		this.setTitle("Image Pool");
	}
	/**
	 * This method initializes poolContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	protected javax.swing.JPanel getPoolContentPane() {
		if(poolContentPane == null) {
			poolContentPane = new javax.swing.JPanel();
			poolContentPane.setLayout(new BoxLayout(poolContentPane, BoxLayout.Y_AXIS));
			poolContentPane.setPreferredSize(new java.awt.Dimension(450,675));
			poolContentPane.add(getPoolPanel(), null);
//			poolContentPane.add(getLoadPanel(), null);
		}
		return poolContentPane;
	}
	/**
	 * This method initializes typePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getTypePanel() {
		if (typePanel == null) {
			typePanel = new JPanel();
			typePanel.setLayout(new BoxLayout(typePanel, BoxLayout.X_AXIS));
			typePanel.add(getTypeScrollPane(), null);
			typePanel.add(getViewPanel(), null);
		}
		return typePanel;
	}
	/**
	 * This method initializes navigationPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getNavigationPanel() {
		if (navigationPanel == null) {
			navigationPanel = new JPanel();
			navigationPanel.add(getFirstButton(), null);
			navigationPanel.add(getLeftButton(), null);
			navigationPanel.add(getRightButton(), null);
			navigationPanel.add(getLastButton(), null);
		}
		return navigationPanel;
	}
	/**
	 * This method initializes loadPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getLoadPanel() {
		if (loadPanel == null) {
			loadPanel = new JPanel();
			loadPanel.setLayout(new FlowLayout());
			loadPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "WEB Database", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.black));
			loadPanel.add(getLoadButton(), null);
			loadPanel.add(getConfigureButton(), null);
		}
		return loadPanel;
	}
	/**
	 * This method initializes firstButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	protected JButton getFirstButton() {
		if (firstButton == null) {
			firstButton = new JButton();
			firstButton.setIcon(firstImageIcon);
			firstButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {
          ilPool.goTop();
				}
			});
		}
		return firstButton;
	}
	/**
	 * This method initializes leftButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	protected JButton getLeftButton() {
		if (leftButton == null) {
			leftButton = new JButton();
			leftButton.setIcon(leftImageIcon);
			leftButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
          ilPool.goBackward();
				}
			});
		}
		return leftButton;
	}
	/**
	 * This method initializes rightButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	protected JButton getRightButton() {
		if (rightButton == null) {
			rightButton = new JButton();
			rightButton.setIcon(rightImageIcon);
			rightButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
          ilPool.goForward();
				}
			});
		}
		return rightButton;
	}
	/**
	 * This method initializes lastButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	protected JButton getLastButton() {
		if (lastButton == null) {
			lastButton = new JButton();
			lastButton.setIcon(lastImageIcon);
			lastButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
          ilPool.goBottom();
				}
			});
		}
		return lastButton;
	}
	/**
	 * This method initializes loadButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	protected JButton getLoadButton() {
		if (loadButton == null) {
			loadButton = new JButton();
			loadButton.setIcon(loadImageIcon);
			loadButton.setText("Load");
			loadButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {
          ilPool.load();
				}
			});
		}
		return loadButton;
	}
	/**
	 * This method initializes typeScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */    
	private JScrollPane getTypeScrollPane() {
		if (typeScrollPane == null) {
			typeScrollPane = new JScrollPane();
			typeScrollPane.setViewportView(getTypeTree());
			typeScrollPane.setPreferredSize(new java.awt.Dimension(82,504));
		}
		return typeScrollPane;
	}
	/**
	 * This method initializes typeTree	
	 * 	
	 * @return javax.swing.JTree	
	 */    
	protected JTree getTypeTree() {
		if (typeTree == null) {
			typeTree = new JTree();
			typeTree.setRootVisible(true);
			typeTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() { 
				public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
          ilPool.nodeSelected(e);
				}
			});
		}
		return typeTree;
	}
	/**
	 * This method initializes poolPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	protected JPanel getPoolPanel() {
		if (poolPanel == null) {
			poolPanel = new JPanel();
			poolPanel.setLayout(new BoxLayout(poolPanel, BoxLayout.Y_AXIS));
			poolPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Local Image Pool", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.black));
			poolPanel.add(getTypePanel(), null);
			poolPanel.add(getNavigationPanel(), null);
			poolPanel.add(getSelectionPanel(), null);
		}
		return poolPanel;
	}
	/**
	 * This method initializes selectionPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getSelectionPanel() {
		if (selectionPanel == null) {
			jLabel = new JLabel();
			FlowLayout flowLayout4 = new FlowLayout();
			selectionPanel = new JPanel();
			selectionPanel.setLayout(flowLayout4);
//TODO WEB database
//    jLabel.setText("Display Images: ");
			flowLayout4.setVgap(0);
//			selectionPanel.add(jLabel, null);
//			selectionPanel.add(getOwnRadioButton(), null);
//			selectionPanel.add(getLoadedRadioButton(), null);
//			selectionPanel.add(getBothRadioButton(), null);
		}
		return selectionPanel;
	}
	/**
	 * This method initializes bothRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */    
	protected JRadioButton getBothRadioButton() {
		if (bothRadioButton == null) {
			bothRadioButton = new JRadioButton();
      bothRadioButton.setSelected(true);
      bothRadioButton.setText("both");
      bothRadioButton.addActionListener(new java.awt.event.ActionListener() { 
      	public void actionPerformed(java.awt.event.ActionEvent e) {
          ilPool.activateView();
      	}
      });
		}
		return bothRadioButton;
	}
	/**
	 * This method initializes loadedRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */    
	protected JRadioButton getLoadedRadioButton() {
		if (loadedRadioButton == null) {
			loadedRadioButton = new JRadioButton();
			loadedRadioButton.setText("loaded");
			loadedRadioButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
          ilPool.activateView();
				}
			});
		}
		return loadedRadioButton;
	}
	/**
	 * This method initializes ownRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */    
	protected JRadioButton getOwnRadioButton() {
		if (ownRadioButton == null) {
			ownRadioButton = new JRadioButton();
			ownRadioButton.setText("own");
			ownRadioButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
          ilPool.activateView();
				}
			});
		}
		return ownRadioButton;
	}
	/**
	 * This method initializes viewPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	protected JPanel getViewPanel() {
		if (viewPanel == null) {
			GridLayout gridLayout1 = new GridLayout();
			viewPanel = new JPanel();
			viewPanel.setLayout(gridLayout1);
			gridLayout1.setRows(5);
			gridLayout1.setColumns(2);
			gridLayout1.setHgap(1);
			gridLayout1.setVgap(1);
			viewPanel.setPreferredSize(new java.awt.Dimension(203,505));
			viewPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0,1,0,1));
		}
		return viewPanel;
	}
	/**
	 * This method initializes configureButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getConfigureButton() {
		if (configureButton == null) {
			configureButton = new JButton();
			configureButton.setIcon(configureImageIcon);
			configureButton.setText("Configure");
			configureButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {
          ilPool.showPreference();
				}
			});
		}
		return configureButton;
	}
                   }  //  @jve:decl-index=0:visual-constraint="10,10"
