/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.pond.ui;

import javax.swing.JDialog;

import java.awt.CardLayout;
import javax.swing.JPanel;
import javax.swing.BoxLayout;
import java.awt.FlowLayout;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JEditorPane;

import kandid.IconLoader;
import kandid.util.Debug;
/**
 * @author thomas jourdan
 *  
 */
public class UiLoadWizzard extends JDialog {
  private static final long serialVersionUID = 1L;

  private javax.swing.JPanel jContentPane = null;

  private JPanel cardPanel = null;
  private JPanel navigationPanel = null;
  private JButton cancelButton = null;
  private JButton nextButton = null;
  private JPanel card1Panel = null;
  private JPanel card2Panel = null;
  private JLabel selectionLabel = null;
  private JRadioButton sameColorRadioButton = null;
  private JRadioButton sameCalculationRadioButton = null;
  private JPanel licensePanel = null;
  private JPanel agreePanel = null;
  private JRadioButton notAgreeRadioButton = null;
  private JRadioButton agreeRadioButton = null;
  private JScrollPane jScrollPane = null;
  private JEditorPane jEditorPane = null;

  private ButtonGroup acceptGroup = new ButtonGroup();
  private ButtonGroup selectionGroup = new ButtonGroup();

  private IlLoadWizzard ilWizzard;

  /**
   * This is the default constructor
   */
  public UiLoadWizzard() {
    super();
    try {
    } catch (Exception exc) {
      Debug.stackTrace(exc);
    }

    initialize();
    acceptGroup.add(notAgreeRadioButton);
    acceptGroup.add(agreeRadioButton);
    selectionGroup.add(sameColorRadioButton);
    selectionGroup.add(sameCalculationRadioButton);
  }
  /**
   * @param ilWizzard
   */
  public UiLoadWizzard(IlLoadWizzard wizzard) {
    this();
    this.ilWizzard = wizzard;
  }
  /**
   * This method initializes this
   * 
   * @return void
   */
  private void initialize() {
    this.setTitle("Creative Commons");
    this.setContentPane(getJContentPane());
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent e) {
        IlPool.getInstance().finalizeLoad(true);
      }
    });
  }
  /**
   * This method initializes jContentPane
   * 
   * @return javax.swing.JPanel
   */
  private javax.swing.JPanel getJContentPane() {
    if (jContentPane == null) {
      jContentPane = new javax.swing.JPanel();
      jContentPane.setLayout(new BoxLayout(jContentPane, BoxLayout.Y_AXIS));
      jContentPane.add(getCardPanel(), null);
      jContentPane.add(getNavigationPanel(), null);
    }
    return jContentPane;
  }
  /**
   * This method initializes cardPanel
   * 
   * @return javax.swing.JPanel
   */
  protected JPanel getCardPanel() {
    if (cardPanel == null) {
      cardPanel = new JPanel();
      cardPanel.setLayout(new CardLayout());
      cardPanel.setName("cardPanel");
      cardPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 5, 0, 5));
      cardPanel.add(getCard1Panel(), getCard1Panel().getName());
      cardPanel.add(getCard2Panel(), getCard2Panel().getName());
    }
    return cardPanel;
  }
  /**
   * This method initializes navigationPanel
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getNavigationPanel() {
    if (navigationPanel == null) {
      FlowLayout flowLayout1 = new FlowLayout();
      navigationPanel = new JPanel();
      navigationPanel.setLayout(flowLayout1);
      navigationPanel.setName("navigationPanel");
      flowLayout1.setAlignment(java.awt.FlowLayout.RIGHT);
      navigationPanel.add(getNextButton(), null);
      navigationPanel.add(getCancelButton(), null);
    }
    return navigationPanel;
  }
  /**
   * This method initializes cancelButton
   * 
   * @return javax.swing.JButton
   */
  private JButton getCancelButton() {
    if (cancelButton == null) {
      cancelButton = new JButton();
      cancelButton.setIcon(IconLoader.cancelImageIcon);
      cancelButton.setText("Cancel");
      cancelButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent e) {
          ilWizzard.cancel();
        }
      });
    }
    return cancelButton;
  }
  /**
   * This method initializes nextButton
   * 
   * @return javax.swing.JButton
   */
  protected JButton getNextButton() {
    if (nextButton == null) {
      nextButton = new JButton();
      nextButton.setIcon(IconLoader.readdbImageIcon);
      nextButton.setText("Load");
      nextButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent e) {
          ilWizzard.next();
        }
      });
    }
    return nextButton;
  }
  /**
   * This method initializes card1Panel
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getCard1Panel() {
    if (card1Panel == null) {
      selectionLabel = new JLabel();
      card1Panel = new JPanel();
      card1Panel.setLayout(new BoxLayout(card1Panel, BoxLayout.Y_AXIS));
      card1Panel.setName("card1Panel");
      selectionLabel.setText("Update your genome pool with public vailable genomes.");
      card1Panel.add(selectionLabel, null);
      card1Panel.add(getSameColorRadioButton(), null);
      card1Panel.add(getSameCalculationRadioButton(), null);
    }
    return card1Panel;
  }
  /**
   * This method initializes card2Panel
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getCard2Panel() {
    if (card2Panel == null) {
      card2Panel = new JPanel();
      card2Panel.setLayout(new BoxLayout(card2Panel, BoxLayout.Y_AXIS));
      card2Panel.setName("card2Panel");
      card2Panel.add(getLicensePanel(), null);
      card2Panel.add(getAgreePanel(), null);
    }
    return card2Panel;
  }
  /**
   * This method initializes sameColorRadioButton
   * 
   * @return javax.swing.JRadioButton
   */
  protected JRadioButton getSameColorRadioButton() {
    if (sameColorRadioButton == null) {
      sameColorRadioButton = new JRadioButton();
      sameColorRadioButton.setText("Update your genome pool with public vailable genomes.");
    }
    return sameColorRadioButton;
  }
  /**
   * This method initializes sameCalculationRadioButton
   * 
   * @return javax.swing.JRadioButton
   */
  protected JRadioButton getSameCalculationRadioButton() {
    if (sameCalculationRadioButton == null) {
      sameCalculationRadioButton = new JRadioButton();
      sameCalculationRadioButton.setText("All %s calculations.");
    }
    return sameCalculationRadioButton;
  }
  /**
   * This method initializes licensePanel
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getLicensePanel() {
    if (licensePanel == null) {
      licensePanel = new JPanel();
      licensePanel.setAlignmentX(0.0F);
      licensePanel.add(getJScrollPane(), null);
    }
    return licensePanel;
  }
  /**
   * This method initializes agreePanel
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getAgreePanel() {
    if (agreePanel == null) {
      agreePanel = new JPanel();
      agreePanel.setLayout(new BoxLayout(agreePanel, BoxLayout.Y_AXIS));
      agreePanel.add(getAgreeRadioButton(), null);
      agreePanel.add(getNotAgreeRadioButton(), null);
    }
    return agreePanel;
  }
  /**
   * This method initializes notAgreeRadioButton
   * 
   * @return javax.swing.JRadioButton
   */
  protected JRadioButton getNotAgreeRadioButton() {
    if (notAgreeRadioButton == null) {
      notAgreeRadioButton = new JRadioButton();
      notAgreeRadioButton.setText("I do not accept the terms in the license agreements");
      notAgreeRadioButton.setSelected(true);
      notAgreeRadioButton.addItemListener(new java.awt.event.ItemListener() {
        public void itemStateChanged(java.awt.event.ItemEvent e) {
          ilWizzard.acceptState();
        }
      });
    }
    return notAgreeRadioButton;
  }
  /**
   * This method initializes agreeRadioButton
   * 
   * @return javax.swing.JRadioButton
   */
  protected JRadioButton getAgreeRadioButton() {
    if (agreeRadioButton == null) {
      agreeRadioButton = new JRadioButton();
      agreeRadioButton.setText("I accept the terms in the license agreements");
      agreeRadioButton.addItemListener(new java.awt.event.ItemListener() {
        public void itemStateChanged(java.awt.event.ItemEvent e) {
          ilWizzard.acceptState();
        }
      });
    }
    return agreeRadioButton;
  }
  /**
   * This method initializes jScrollPane
   * 
   * @return javax.swing.JScrollPane
   */
  private JScrollPane getJScrollPane() {
    if (jScrollPane == null) {
      jScrollPane = new JScrollPane();
      jScrollPane.setViewportView(getJEditorPane());
      jScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
      jScrollPane.setPreferredSize(new java.awt.Dimension(450, 350));
    }
    return jScrollPane;
  }
  /**
   * This method initializes jEditorPane
   * 
   * @return javax.swing.JEditorPane
   */
  private JEditorPane getJEditorPane() {
    if (jEditorPane == null) {
      jEditorPane = new JEditorPane();
      jEditorPane
          .setText("All downloaded images are under a\n"
              + "Creative Commons License\n"
              + "Attribution-NonCommercial-ShareAlike 2.0\n"
              + "\n"
              + "You are free:\n"
              + "    * to copy, distribute, display, and perform the work\n"
              + "    * to make derivative works\n"
              + "\n"
              + "Under the following conditions:\n"
              + "\n"
              + "    Attribution. You must give the original author credit.\n"
              + "\n"
              + "    Noncommercial. You may not use this work for commercial purposes.\n"
              + "\n"
              + "    Share Alike. If you alter, transform, or build upon this work, you may\n"
              + "      distribute the resulting work only under a license identical to this one.\n"
              + "\n"
              + "   * For any reuse or distribution, you must make clear to others the\n"
              + "      license terms of this work.\n"
              + "   * Any of these conditions can be waived if you get permission from\n"
              + "      the copyright holder.\n"
              + "\n"
              + "Your fair use and other rights are in no way affected by the above.");
      jEditorPane.setEditable(false);
    }
    return jEditorPane;
  }
}