/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.pond.ui;

/**
 * @author thomas jourdan
 *  
 */
public class IlLoadWizzard {

  private UiLoadWizzard uiLoadWizzard;
  private int card;
  private static IlLoadWizzard ilWizzard = null;
  private String queryCalulationName;
  private String queryColoratorName;

  public void initialize() {
    uiLoadWizzard = new UiLoadWizzard(this);
    uiLoadWizzard.getAgreeRadioButton().setSelected(false);
    uiLoadWizzard.getNotAgreeRadioButton().setSelected(true);
    uiLoadWizzard.getSameColorRadioButton().setSelected(true);
    card = 1;
    manageCard();
  }

  /**
   *  
   */
  public void cancel() {
    IlPool.getInstance().finalizeLoad(true);
    uiLoadWizzard.setVisible(false);
    uiLoadWizzard.dispose();
  }

  /**
   *  
   */
  public void next() {
    acceptState();
    switch (card) {
      case 0 :
        card = 1;
        manageCard();
        break;
      case 1 :
// TODO WEB database
//        if (uiLoadWizzard.getAgreeRadioButton().isSelected()) {
//          HttpLoader.updateFromDB(queryCalulationName, queryColoratorName);
//          uiLoadWizzard.setVisible(false);
//          uiLoadWizzard.dispose();
//        }
        break;
    }
  }

  private void manageCard() {
    acceptState();
    switch (card) {
      case 0 :
        ((java.awt.CardLayout) uiLoadWizzard.getCardPanel().getLayout()).first(uiLoadWizzard.getCardPanel());
        break;
      case 1 :
        ((java.awt.CardLayout) uiLoadWizzard.getCardPanel().getLayout()).last(uiLoadWizzard.getCardPanel());
        break;
    }
  }

  public void acceptState() {
    uiLoadWizzard.getNextButton().setEnabled(uiLoadWizzard.getAgreeRadioButton().isSelected());
  }

  public static IlLoadWizzard showInstance() {
    if (ilWizzard == null) {
      ilWizzard = new IlLoadWizzard();
      ilWizzard.initialize();
      ilWizzard.uiLoadWizzard.pack();
    }
    ilWizzard.uiLoadWizzard.setVisible(true);
    return ilWizzard;
  }

  public static void main(String args[]) {
    IlLoadWizzard ilLoadWizzard = IlLoadWizzard.showInstance();
    ilLoadWizzard.setQueryCalulationName("kandid.calculation.vm.scalar.ScalarExpressionCalculation");
    ilLoadWizzard.setQueryColoratorName("kandid.colorator.GrayColorator");
  }
    
  /**
   * @param queryCalulationName The queryCalulationName to set.
   */
  public void setQueryCalulationName(String queryCalulationName) {
    this.queryCalulationName = queryCalulationName;
  }
  /**
   * @param queryColoratorName The queryColoratorName to set.
   */
  public void setQueryColoratorName(String queryColoratorName) {
    this.queryColoratorName = queryColoratorName;
  }
}