/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.pond.test;

import javax.xml.bind.JAXBException;

import junit.framework.TestCase;
import kandid.pond.BreederType;
import kandid.pond.util.BreederSearchThread;
import kandid.preference.KandidType;
import kandid.preference.PreferenceType;
import kandid.preference.UserType;
import kandid.util.Debug;

/**
 * 
 * @author thomas jourdan
 */
public class BreederRequestThreadTest extends TestCase {

  /**
   * Constructor for BreederRequestThreadTest.
   * @param arg0
   */
  public BreederRequestThreadTest(String arg0) {
    super(arg0);
  }

  public static PreferenceType getTestPreferences() throws JAXBException {
    kandid.preference.ObjectFactory objectFactory = new kandid.preference.ObjectFactory();
    PreferenceType preferences = objectFactory.createPreferenceType();
    
    KandidType kandidType = objectFactory.createKandidType();
    kandidType.setHome("http://localhost");
    preferences.setKandid(kandidType);
    
    UserType user = objectFactory.createUserType();
    user.setNickname("");
    user.setEmail("t@mausfahrer.de");
    preferences.setUser(user);
    return preferences;
  }
  
  public void testRun() throws JAXBException {
    for (int ti = 1; ti <= 3; ++ti) {
      BreederSearchThread breederSearchThread = BreederSearchThread.getBreederRequestThread();
      breederSearchThread.searchRandomBreeder(getTestPreferences(), null);
      try {
        breederSearchThread.join();
      } catch (InterruptedException exc) {
        Debug.stackTrace(exc);
        assertTrue(false);
      }
      BreederType breederType = breederSearchThread.getBreederType();
      assertTrue(breederType != null);
      assertEquals("kandid (dot) genepool (at) mausfahrer (dot) de", breederType.getEmail());

      //      BreederRequestThread breederRequestThread = BreederRequestThread.getBreederRequestThread();
      //      breederRequestThread.setPreferences(preferences);
      //      System.out.println("start " + ti);
      //      breederRequestThread.start();
      //      ConnectingDialog connectingDialog = new ConnectingDialog(null, false, breederRequestThread);
      //      connectingDialog.show();
      //      try {
      //        breederRequestThread.join();
      //      } catch (InterruptedException exc) {
      //        assertTrue(false);
      //      }
      //      System.out.println("join " + ti);
      //      if (connectingDialog.isStoped()) {
      //      } 
      //      else {
      //        BreederType breederType = breederRequestThread.getBreederType();
      //        assertTrue(breederType != null);
      //        assertEquals("kandid (dot) genepool (at) mausfahrer (dot) de", breederType.getEmail());
      //        connectingDialog.dispose();
      //      }
    }
  }

}
