package kandid.noise;


import junit.framework.TestCase;

public class PseudoRandomizerTest extends TestCase {

  public void testNext() {
    PseudoRandomizer prn1 = new PseudoRandomizer(1512);
    PseudoRandomizer prn2 = new PseudoRandomizer(1512);
    long[] r1 = new long[100];
    for(int nx=0; nx<r1.length; ++nx) {
      r1[nx] = prn1.next(0x7fffffff);
      assertEquals(r1[nx], prn2.next(0x7fffffff));
    }
    prn1.setSeed(1512);
    for(int nx=0; nx<r1.length; ++nx) {
      assertEquals(r1[nx], prn1.next(0x7fffffff));
    }
  }

  public void testUniform() {
    PseudoRandomizer prn1 = new PseudoRandomizer(1512);
    PseudoRandomizer prn2 = new PseudoRandomizer(1512);
    double[] r1 = new double[100];
    for(int nx=0; nx<r1.length; ++nx) {
      r1[nx] = prn1.uniform();
      assertEquals(r1[nx], prn2.uniform(), 0.0);
    }
    prn1.setSeed(1512);
    for(int nx=0; nx<r1.length; ++nx) {
      assertEquals(r1[nx], prn1.uniform(), 0.0);
    }
  }

  public void testGaussian() {
    PseudoRandomizer prn1 = new PseudoRandomizer(1512);
    PseudoRandomizer prn2 = new PseudoRandomizer(1512);
    double[] r1 = new double[100];
    for(int nx=0; nx<r1.length; ++nx) {
      r1[nx] = prn1.gaussian();
      assertEquals(r1[nx], prn2.gaussian(), 0.0);
    }
    prn1.setSeed(1512);
    for(int nx=0; nx<r1.length; ++nx) {
      assertEquals(r1[nx], prn1.gaussian(), 0.0);
    }
  }

}
