/*
 * Copyright 2013, Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package kandid.noise;

import javax.vecmath.Vector3d;

public class PerlinTurbulence3D {
  private PerlinNoise noiseGenerator;
  private int octaves;
//  private double xmin;
//  private double xmax;
//  private double ymin;
//  private double ymax;
//  private double zmin;
//  private double zmax;
//  private double xfactor;
//  private double yfactor;
//  private double zfactor;
  
  public PerlinTurbulence3D() {
    super();
    this.noiseGenerator = new PerlinNoise(-1);
//    calibrate();
  }

  Vector3d calculateNoise(Vector3d point) {
    Vector3d vnoise = new Vector3d();
    this.noiseGenerator.uturbulence3d(point.x, point.y, point.z, this.octaves, 0.5, 2.0, vnoise);
//    vnoise.x = 2.0 * vnoise.x - 1.0;
//    vnoise.y = 2.0 * vnoise.y - 1.0;
//    vnoise.z = 2.0 * vnoise.z - 1.0;
    return vnoise;
  }

  // TODO use calibrate to scale result value??
//  protected void calibrate() {
//    Vector3d point = new Vector3d();
//    Vector3d noiseValue = calculateNoise(point);
//    this.xmin = noiseValue.x;
//    this.xmax = noiseValue.x;
//    this.ymin = noiseValue.y;
//    this.ymax = noiseValue.y;
//    this.zmin = noiseValue.z;
//    this.zmax = noiseValue.z;
//
//    for(double sx=-1.0; sx<=1.0; sx += 0.2) {
//      point.x = sx;
//      for(double sy=-1.0; sy<=1.0; sy += 0.2) {
//        point.y= sx;
//        for(double sz=-1.0; sz<=1.0; sz += 0.2) {
//          point.z= sx;
//          noiseValue = calculateNoise(point);
//          if(noiseValue.x < this.xmin) {
//            this.xmin = noiseValue.x;
//          }
//          else if(noiseValue.x > this.xmax) {
//            this.xmax = noiseValue.x;
//          }
//          if(noiseValue.y < this.ymin) {
//            this.ymin = noiseValue.y;
//          }
//          else if(noiseValue.y > this.ymax) {
//            this.ymax = noiseValue.y;
//          }
//          if(noiseValue.z < this.zmin) {
//            this.zmin = noiseValue.z;
//          }
//          else if(noiseValue.z > this.zmax) {
//            this.zmax = noiseValue.z;
//          }
//        }
//      }
//    }
//    
//    double diffX = this.xmax - this.xmin;
//    double diffY = this.ymax - this.ymin;
//    double diffZ = this.zmax - this.zmin;
//    double diff = diffX > diffY ? diffX : diffY;
//    diff = diffZ > diff ? diffZ : diff;
//    if (diff > 0.0) {
//      this.xfactor = 1.0 / diff;
//      this.yfactor = 1.0 / diff;
//      this.zfactor = 1.0 / diff;
//    }
//    else {
//      this.xfactor = 1.0;
//      this.yfactor = 1.0;
//      this.zfactor = 1.0;
//    }
//  }

  @Override
  public String toString() {
    return "PerlinTurbulence3D [octaves=" + this.octaves + ", toString()=" + super.toString() + "]";
  }

}
