package kandid.input;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;

public class ImageList {
	/**
	 * Search for files none recursively.
	 * 
	 * @param directory Starting folder.
	 * @param endswith File names are accepted if they end with this pattern.
	 * @return A list of file names with the specified pattern.
	 */
	public static File[] listFiles(File directory, final String endswith) {
		assert endswith != null && endswith.length() > 0;
		// Are there some "*.endswith" files?
		File[] entries = directory.listFiles(new FilenameFilter() {
			@Override
			public boolean accept(File entry, String name) {
				return name.endsWith(endswith);
			}
		});
		Arrays.sort(entries);
		return entries;
	}

}
