package kandid.input;

import java.io.File;

import kandid.Kandid;

public class ImageCache {
  static File[] ifl;
  static GrayImage[] cache;
  
  public static void load() {
    ifl = ImageList.listFiles(new File(Kandid.localImageFolder + "/input"), ".png");
    cache = new GrayImage[ifl.length];
    for (int i = 0; i < ifl.length; i++) {
      cache[i] = new GrayImage();
      cache[i].load(ifl[i]);
    }
  }
  
  public static double at(int i, double x, double y) {
    return cache[i % cache.length].at(x, y);
  }
  
  public static void main(String[] args) {
    ImageCache.load();
    for (int i = 0; i < ifl.length; i++) {
      System.out.println(ImageCache.at(i, 0.0, 0.0) + " / " + ImageCache.at(i, 0.99, 0.99));
    }
    System.out.println();
  }
}
