package kandid.input;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class GrayImage {
  private int width;
  private int height;
  double[][] bufImg;

  public void load(File fin) {
    try {
      BufferedImage iin = ImageIO.read(fin);
      height = iin.getHeight();
      width = iin.getWidth();
      bufImg = new double[height][];
      for (int iy = 0; iy < height; ++iy) {
        bufImg[iy] = new double[width];
        for (int ix = 0; ix < width; ++ix) {
          int rgb8 = iin.getRGB(ix, iy);
          int r = (rgb8 >> 16) & 0xff;
          int g = (rgb8 >> 8) & 0xff;
          int b = rgb8 & 0xff;
          bufImg[iy][ix] = (0.30 * r + 0.59 * g + 0.11 * b) / 256.0;
        }
      }
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public double at(double x, double y) {
    int ix = (int) ((Math.abs(x) % 1.0) * width);
    if(ix >= width)
      ix = width - 1;
    int iy = (int) ((Math.abs(y) % 1.0) * height);
    if(iy >= height)
      iy = height - 1;
    return bufImg[iy][ix];
  }
}
