/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.extensions;

import java.awt.Dimension;

import kandid.util.Debug;

/**
 * @author thomas jourdan
 *
 */
public class CachedImageInfo implements Cloneable {
  /** key */
  String id;
  /** image size  */
  Dimension dim;
  /** timestamp of last read access  */
  long stamp;
  /**
   * Method clone
   *
   * @return
   */

  public Object clone() {
    CachedImageInfo cachedImageInfo = null;
    try {
      cachedImageInfo = (CachedImageInfo)super.clone();
      cachedImageInfo.id = null;
      cachedImageInfo.dim = (Dimension)dim.clone();
      cachedImageInfo.stamp = stamp;
    } catch (CloneNotSupportedException exc) {
      Debug.stackTrace(exc);
    }
    return cachedImageInfo;
  }

}
