/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.colorator;

/**
 * Base class for colorators.
 * @author thomas jourdan
 */
public interface Colorator {
  /**
   * Convert value to gray scale
   *
   * @param value a value between 0.0 (inclusive) and 1.0 (exclusive).
   * @param cout TODO
   */
  public void getColor(double value, ColorF32 cout);
  
  /**
   * Converts three RGB values to internal color representation.
   *
   * @param redValue
   * @param greenValue
   * @param blueValue
   * @param cout TODO
   */
  public void getColor(double redValue, double greenValue, double blueValue, ColorF32 cout);

  /**
   * Method getColor.
   * @param colorGene
   * @param cout TODO
   */
  public void getColor(kandid.soup.ColorGene colorGene, ColorF32 cout);

  /**
   * Method getColor.
   * @param color
   * @param cout TODO
   */
  public void getColor(java.awt.Color color, ColorF32 cout);

  /**
   * Method getShortName.
   * @return String
   */
  public String getShortName();
  
  /**
   * Method colorTable.
   * @param value
   */
  public void setColorTable(kandid.soup.ChromosomeType colorTable);

  /**
   * Get color value from a look up table.
   *
   * @param index an index between 0 and colorTable.length-1.
   * @param cout TODO
   */
  public void getDiscretColor(int index, ColorF32 cout);
  
  /**
   * Get number of entries in the color table.
   *
   * @return a number >= 2.
   */
  public int getNumberOfDiscretColors();
  
}
