package kandid.colorator;

import junit.framework.Assert;
import junit.framework.TestCase;

public class ColorF32Test extends TestCase {

  public void testHsb() {
    {
    ColorF32 color_in = new ColorF32(0, 0, 0);
    ColorF32 expected_hsb = new ColorF32(0, 0, 0);
    convert(ColorF32.black, expected_hsb, color_in);
    }
    {
    ColorF32 expected_hsb = new ColorF32(0, 0, 1);
    ColorF32 color_in = new ColorF32(1, 1, 1);
    convert(ColorF32.white, expected_hsb, color_in);
    }
    {
    ColorF32 expected = new ColorF32(1, 0, 0);
    ColorF32 expected_hsb = new ColorF32(0, 1, 1);
    ColorF32 color_in = new ColorF32(1, 0, 0);
    convert(expected, expected_hsb, color_in);
    }
    {
    ColorF32 expected = new ColorF32(0, 0.5f, 0.7f);
    ColorF32 expected_hsb = new ColorF32(0.54761904f, 1, 0.7f);
    ColorF32 color_in = new ColorF32(0, 0.5f, 0.7f);
    convert(expected, expected_hsb, color_in);
    }
    {
    ColorF32 expected = new ColorF32(0.1f, 0.2f, 0.3f);
    ColorF32 expected_hsb = new ColorF32(0.5833333f, 0.6666667f, 0.3f);
    ColorF32 color_in = new ColorF32(0.1f, 0.2f, 0.3f);
    convert(expected, expected_hsb, color_in);
    }
    {
    ColorF32 expected = new ColorF32(0.2f, 0.3f, 0.1f);
    ColorF32 expected_hsb = new ColorF32(0, 0, 0.3f);
    ColorF32 color_in = new ColorF32(0.2f, 0.3f, 0.1f);
    convert(expected, expected_hsb, color_in);
    }
  }

  private void convert(ColorF32 expectedRGB, ColorF32 expectedHSB, ColorF32 color_in) {
    ColorF32 color_out = new ColorF32(0, 0, 0);
    ColorF32 hsb = new ColorF32();
    ColorF32.rgb2hsb(color_in, hsb);
    System.out.println("rgb " + expectedRGB + " hsb " + hsb);
    if(expectedHSB != null) {
      Assert.assertEquals(expectedHSB.r, hsb.r, 0.5000001f);
      Assert.assertEquals(expectedHSB.g, hsb.g, 0.5000001f);
      Assert.assertEquals(expectedHSB.b, hsb.b, 0.5000001f);
    }
    ColorF32.hsb2rgb(hsb, color_out);
    Assert.assertEquals(expectedRGB.r, color_out.r, 0.5000001f);
    Assert.assertEquals(expectedRGB.g, color_out.g, 0.5000001f);
    Assert.assertEquals(expectedRGB.b, color_out.b, 0.5000001f);
  }

}
