/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.catalog.test;

import java.util.Iterator;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import junit.framework.TestCase;
import kandid.catalog.*;

/**
 * 
 * @author thomas jourdan
 */
public class CatalogTypeImplTest extends TestCase {

  /**
   * Constructor for CatalogTypeImplTest.
   * @param arg0
   */
  public CatalogTypeImplTest(String arg0) {
    super(arg0);
  }

  public void testGetType() throws JAXBException {
    int found = 0;
    JAXBContext jc = JAXBContext.newInstance("kandid.catalog");
    Unmarshaller u = jc.createUnmarshaller();
    javax.xml.bind.JAXBElement uo = (JAXBElement) u.unmarshal(getClass().getResourceAsStream("/kandid/catalog/catalog.xml"));
    kandid.catalog.CatalogType catalog = (kandid.catalog.CatalogType) uo.getValue();
    java.util.List<CalculationType> calculationList = catalog.getCalculation();
    for (Iterator<CalculationType> iterCalculation = calculationList.iterator(); iterCalculation.hasNext();) {
      CalculationType calculation = iterCalculation.next();
      if (calculation.getName().equals("Voronoi")) {
        java.util.List<ModelType> modelList = calculation.getModel();
        for (Iterator<ModelType> iterModel = modelList.iterator(); iterModel.hasNext();) {
          ModelType model = iterModel.next();
          if(model.getCalculationClass().equals("kandid.calculation.voronoi.VoronoiCalculation")
             && model.getColoratorClass().equals("kandid.colorator.RGBColorator")) {
            ++found;
          }
        }
      }
    }
    assertTrue(found == 1);
  }

}
