/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.voronoi;

import junit.framework.TestCase;

/**
 * 
 * @author thomas jourdan
 */
public class PairListTest extends TestCase {

  /**
   * Constructor for PairListTest.
   * @param arg0
   */
  public PairListTest(String arg0) {
    super(arg0);
  }

  public void testInsert() {
    PairList pairList1 = new PairList(1);
    pairList1.insert(new Pair(1.0, 1));
    assertTrue(pairList1.getKing(0) == 1);
    
    PairList pairList2 = new PairList(2);
    pairList2.insert(new Pair( 0.0, 0));
    pairList2.insert(new Pair( 1.0, 1));
    pairList2.insert(new Pair(-1.0, 2));
    assertTrue(pairList2.getKing(0) == 2);
    assertTrue(pairList2.getKing(1) == 0);
    
    PairList pairList3 = new PairList(5);
    pairList3.insert(new Pair( 0.0, 10));
    pairList3.insert(new Pair( 1.0, 11));
    pairList3.insert(new Pair(-1.0, 12));
    assertTrue(pairList3.getKing(0) == 12);
    
    pairList3.insert(new Pair(-2.0, 13));
    assertTrue(pairList3.getKing(0) == 13);
    
    pairList3.insert(new Pair( 2.0, 14));
    assertTrue(pairList3.getKing(4) == 14);
    
    pairList3.insert(new Pair(-0.5, 15));
    assertTrue(pairList3.getKing(3) == 10);
    
    pairList3.insert(new Pair(-2.5, 16));
    assertTrue(pairList3.getKing(0) == 16);
    assertTrue(pairList3.getKing(1) == 13);
    assertTrue(pairList3.getKing(2) == 12);
    assertTrue(pairList3.getKing(3) == 15);
    assertTrue(pairList3.getKing(4) == 10);
    
  }

}
