/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.voronoi;

public class PairList {
  private int  size;
  private Pair pairlist[];
  private int  entries;
  
  /**
   * Method PairList.
   * @param size
   */
  public PairList(int size) {
    this.size = size;
    pairlist = new Pair[size];
    entries = 0;
  }

  /**
   * insert and sort by distance.
   * @param pair
   */
  public void insert(Pair pair) {
    int ix = 0;
    while (ix < entries && ix < size) {
      if (pair.distance < pairlist[ix].distance) {
        for (int mx = size - 1; mx > ix; --mx) {
          pairlist[mx] = pairlist[mx - 1];
        }
        break;
      } else {
        ++ix;
      }
    }
    if (ix < size) {
      pairlist[ix] = pair;
      ++entries;
    }
  }

  /**
   * get king sorted by distance.
   * @param priority
   * @return int
   */
  public int getKing(int priority) {
    return pairlist[priority] == null ? -1 : pairlist[priority].king;
  }
}
