package kandid.calculation.vm.scalar;

public class Deviation extends kandid.calculation.Deviation {
  final double x_from = 0.05;
  final double x_to   = 0.95;
  final double y_from = 0.33;
  final double y_to   = 0.66;
  final double z_from = 0.65;
  final double z_to   = 0.05;
  final public double x;
  final public double y;
  final public double z;

  public Deviation(int frame, int frames, boolean stop) {
    super(frame, stop);
    x = x_from + (double)frame * ((x_to - x_from) / (double)frames);
    y = y_from + (double)frame * ((y_to - y_from) / (double)frames);
    z = z_from + (double)frame * ((z_to - z_from) / (double)frames);
  }
}
