/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.lsys;

import junit.framework.TestCase;

/**
 * @author thomas jourdan
 */
public class LsysMashineTest extends TestCase {

  /**
   * Constructor for LsysMashineTest.
   * @param name
   */
  public LsysMashineTest(String name) {
    super(name);
  }
  
  public void testToAlpha() {
    int counter;
    counter = -1000;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    assertEquals(0.0f, LsysMashine.toAlpha(counter), Float.MIN_VALUE);
    counter = -100;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = -10;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = -5;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = -2;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = -1;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = 0;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    assertEquals(0.5f, LsysMashine.toAlpha(counter), Float.MIN_VALUE);
    counter = 1;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = 2;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = 5;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = 10;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = 100;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    counter = 1000;    System.out.println(counter + ": " + LsysMashine.toAlpha(counter));
    assertEquals(1.0f, LsysMashine.toAlpha(counter), Float.MIN_VALUE);
  }

  public void testContext() {
    LsysMashine.initIgnore("+-");
    //                       012345678901234567890123
    lContext(false, 0, 'A', "ABC[DE][SG[HI[JK]L]MNO]P");
    lContext(true, 19, 'G', "ABC[DE][SG[HI[JK]L]MNO]P");
    lContext(true,  1, 'A', "ABC[DE][SG[HI[JK]L]MNO]P");
    lContext(true,  8, 'C', "ABC[DE][SG[HI[JK]L]MNO]P");
    lContext(true, 14, 'I', "ABC[DE][SG[HI[JK]L]MNO]P");
    lContext(true, 23, 'C', "ABC[DE][SG[HI[JK]L]MNO]P");

    //                      012345678901234567890123
    lContext(true, 3, 'F', "F[[A");
    lContext(true, 3, 'F', "F[]A");
    lContext(true, 4, 'F', "F[B]A");
    lContext(true, 5, 'F', "F[B][A");
    lContext(true, 6, 'C', "F[B]C[A");
    lContext(true, 5, 'B', "F[B[[A");
    lContext(true, 7, 'F', "F[[B]][A");
    lContext(true, 9, 'F', "F[[B]+][-A");
    lContext(true, 9, 'F', "F-[[B]]+[A");
    
    //                      012345678901234567890123
    rContext(true, 0, 'B', "F[A]B");
    rContext(true, 0, 'C', "F[AB]C");
    rContext(true, 2, 'B', "F[AB]C");
    rContext(false,3, 'C', "F[AB]C");
    rContext(true, 0, 'B', "F[]B");
    rContext(false,0, 'A', "F[[A");
    rContext(false,3, 'A', "F[[A");
    rContext(true, 0, 'B', "F[][A]B");
    rContext(true, 0, 'G', "F[AB[CD]E]G");
    rContext(true, 3, 'E', "F[AB[CD]E]G");
    rContext(false,3, 'C', "F[AB[CD]E]G");
    rContext(false,6, 'E', "F[AB[CD]E]G");
    //                      012345678901234567890123
    rContext(true, 3, 'E', "F[AB+[+C+D+]+E+]+G+");
    rContext(true, 3, 'E', "F[AB[CD]--E]G");
    rContext(true, 3, 'E', "F[AB[CD---]E]G");
  }

  private void lContext(boolean expected, int at, char testChar, String string) {
    LsysMashine.string = toByteArray(string);
    LsysMashine.length = LsysMashine.string.length;
    assertEquals(expected, LsysMashine.testLeftContext(at, (byte)testChar));
  }

  private void rContext(boolean expected, int at, char testChar, String string) {
    LsysMashine.string = toByteArray(string);
    LsysMashine.length = LsysMashine.string.length;
    assertEquals(expected, LsysMashine.testRightContext(at, (byte)testChar));
  }

  private byte[] toByteArray(String str) {
    byte[] ret = new byte[str.length()];
    for (int ix = 0; ix < ret.length; ix++) {
      ret[ix] = (byte)str.charAt(ix);
    }
    return ret;
  }

}
