/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.lsys;

import kandid.calculation.Deviation;
import kandid.calculation.VectorCalculation;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.soup.LsysChromosome;
import kandid.soup.genetic.lsys.LsysGenetic;

public class LsysCalculation extends VectorCalculation {

  boolean ready;
  boolean deferred;

  /* For documentation please see super class VectorCalculation. */
  public boolean reject(ChromosomeType chromosome) {
    ready = false;
    return LsysGenetic.reject((LsysChromosome)chromosome);
  }

  /* For documentation please see super class VectorCalculation. */
  public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
    super.setChromosome(chromosome, colorator);
    ready = false;
  }

  /**
   * returns true if an calculation is queed but deferred.
   */
  public boolean getDeferred() {
    return deferred;
  }

  /* For documentation please see super class VectorCalculation. */
  public void calculate(Deviation dev, boolean paintOnScreen, String doExport) {
    deferred = true;
    LsysMashine.execute(chromosome, colorator, this);
    deferred = false;
    ready = true;
  }

  /* For documentation please see super class VectorCalculation. */
  public int getPercent() {
    return -1;
//    if(deferred)
//      return 0;
//    if(ready)
//      return 100;
//    System.out.println("state " + LsysMashine.calculationState);
//    if(LsysMashine.calculationState > 1) {
//      System.out.println("percent " + ((100 * LsysMashine.turtleIndex) / LsysMashine.length));
//      return (100 * LsysMashine.turtleIndex) / LsysMashine.length;
//    }
//    return 0;
  }

  /* For documentation please see super class VectorCalculation. */
  public boolean getReady() {
    return aborted || ready;
  }

  /* For documentation please see super class VectorCalculation. */
  public boolean hasWhiteBackground() {
    return true;
  }


}
