/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.lca;

import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;
import kandid.soup.DirectLcaChromosome;
import kandid.soup.LcaStateGene;

/**
 *
 * @author thomas jourdan
 */
public class DirectLcaCalculation extends LcaCalculation implements Cloneable {
  
  public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
    super.setChromosome(chromosome, colorator);
    DirectLcaChromosome lcaChromosome = (DirectLcaChromosome)chromosome;
    maxStates = lcaChromosome.getMaxStates().getValue();
    size   = width * width;
    totalDisplayRows = width;
    actDisplayRow    = 0;
    neighbors        = lcaChromosome.getLeftNeighbors().getValue() + 1 + lcaChromosome.getRightNeighbors().getValue();
    // initialize cell array
    state            = new int[width];
    setRandomFirstState();
    nextState        = new int[width];
    // initialize rules
    java.util.List<LcaStateGene> ruleList = lcaChromosome.getRule();
    rule = new int[ruleList.size()];
    for (int px = 0; px < rule.length; ++px) {
      rule[px] = ruleList.get(px).getValue();
    }
    // initialize palette
    intPalette = new ColorF32[lcaChromosome.getColor().size()];
    java.util.List<ColorGene> colorList = lcaChromosome.getColor();
    for (int px = 0; px < intPalette.length; ++px) {
      intPalette[px] = new ColorF32();
      colorator.getColor(colorList.get(px), intPalette[px]);
    }
  }

  public static int numberofRules(int maxStates, int leftNeighbors, int rightNeighbors) {
    int nr = 1;
    int nb = leftNeighbors + 1 + rightNeighbors;
    for (int ix = 0; ix < nb; ix++) {
      nr *= maxStates;
    }
    return nr;
  }
  
  /* For documentation please see super class LcaCalculation. */
  protected int getRuleNumber(int index, int maxStates) {
    // calculate sum of all neighbors
    int ruleNumber = 0;
    for (int nx = 0; nx < neighbors; nx++) {
      ruleNumber *= maxStates;
      ruleNumber += state[(index + nx) % state.length];
    }
    return ruleNumber;
  }

  public boolean hasWhiteBackground() {
    return false;
  }
}
