package kandid.calculation.domainwarping;

public class Deviation extends kandid.calculation.Deviation {

  public final double s1;
  public final double s2;
  public final double s3;
  public final double s4;
  final double s1_from = 0.25;
  final double s1_to   = 0.75;
  final double s2_from = 0.33;
  final double s2_to   = 0.66;
  final double s3_from = 0.66;
  final double s3_to   = 0.33;
  final double s4_from = 0.05;
  final double s4_to   = 0.95;

  public Deviation(int frame, int frames, boolean stop) {
    super(frame, stop);
    s1 = s1_from + (double)frame * ((s1_to - s1_from) / (double)frames);
    s2 = s2_from + (double)frame * ((s2_to - s2_from) / (double)frames);
    s3 = s3_from + (double)frame * ((s3_to - s3_from) / (double)frames);
    s4 = s4_from + (double)frame * ((s4_to - s4_from) / (double)frames);
  }

}
