/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge.flame;

import java.awt.Dimension;

import junit.framework.TestCase;
import kandid.Kandid;
import kandid.calculation.bridge.BatchJob;
import kandid.soup.ChromosomeType;
import kandid.soup.PopulationType;
import kandid.soup.test.SoupFactoryTest;
import kandid.soup.util.SoupFactory;
import kandid.util.CentralRandomizer;

/**
 * @author thomas jourdan
 *
 */
public class FlameJobTest extends TestCase {

  private static final int height = 200;
  private static final int width = 100;

  /**
   * Constructor for FlameJobTest.
   * @param name
   */
  public FlameJobTest(String name) {
    super(name);
  }

  public void testTryExecute() {
    (new FlameJob()).tryExecute();
  }

  public void testCreateJob() {
    SoupFactory soupFactory = SoupFactory.getSoupFactory();
    CentralRandomizer.setSeed(1512);
    PopulationType population = SoupFactoryTest.createRandomPopulation(soupFactory, "FlameIfs", "FlameCalculation", "kandid.colorator.RGBColorator");
    ChromosomeType aChromosome = soupFactory.getChromosome(population, 0);

    Dimension dim = new Dimension(width, height);

    FlameJob flameJob_p = new FlameJob();
    flameJob_p.createJob(aChromosome, dim, true, null, "png");
    assertEquals("png", flameJob_p.imageFormat);
    assertTrue(flameJob_p.childProgram.length() > 0);
    assertEquals(1, flameJob_p.comandline.length);
    assertEquals(3, flameJob_p.environment.length);
    assertTrue(flameJob_p.script.length() > 0);
    assertEquals(Kandid.scratchFolder + "/FlameIfs_a_1__p.flam3", flameJob_p.scriptFileName);
    assertEquals(Kandid.scratchFolder + "/FlameIfs_a_1__p.png", flameJob_p.imageFileName);

    FlameJob flameJob_f = new FlameJob();
    flameJob_f.createJob(aChromosome, dim, false, null, "png");
    assertEquals(Kandid.scratchFolder + "/FlameIfs_a_1__f.flam3", flameJob_f.scriptFileName);
    assertEquals(Kandid.scratchFolder + "/FlameIfs_a_1__f.png", flameJob_f.imageFileName);
    String expexted = "<test>\n"
    + "<flame time=\"0\" palette=\"54\" size=\"100 200\" center=\"0 0\" scale=\"9.765625\" zoom=\"3.602431440435451\" oversample=\"1\" filter=\"3.396662307752609\" quality=\"20\" batches=\"10\" background=\"0 0 0\" brightness=\"1.0398859799635196\" gamma=\"3.2066153290970916\" vibrancy=\"0.6084969122800752\" hue=\"0.3080638416465201\">\n"
    + "   <xform weight=\"0.2405056286244176\" color=\"0.9948996377051645\" var=\" 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.34449906748812664 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"0.9828217143287434 -0.4773674597069921 0.24142741974291226 -0.7798920282746804 -0.33089421490473536 0.6460737228636082\"/>\n"
    + "   <xform weight=\"0.38656828233525986\" color=\"0.6509797989031093\" var=\" 0.0 0.0 0.550588264937501 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.12680096891820924 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"0.441479847643687 0.4368083170902426 -0.005475518842098737 0.5642545541811674 0.6193595995068664 -0.7710061594655429\"/>\n"
    + "   <xform weight=\"0.8311117894105511\" color=\"0.22182524852469165\" var=\" 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.6588616979308334 0.09852606284334153 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"0.8777127189125451 0.9121963456443518 0.9111784184362024 0.729058524443607 -0.541091004846751 0.9532627571467451\"/>\n"
    + "   <xform weight=\"0.20296689206861585\" color=\"0.8298179566528179\" var=\" 0.0 0.0 0.0 0.9257674580503036 0.0 0.10739803672465875 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"-0.2933686266446258 -0.8324480854167104 0.2140977067619354 0.253200040828236 0.32755913484065013 0.0192578143264992\"/>\n"
    + "   <xform weight=\"0.1478857398990765\" color=\"0.7955308459606585\" var=\" 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.6286451417493168 0.0 0.8984522404129824 0.8551959857602653 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"-0.3658573446625395 -0.2708311153648184 -0.592842557983225 0.593662237940576 -0.3690425246737865 0.7066800013272738\"/>\n"
    + "   <xform weight=\"0.6845974981115861\" color=\"0.2812539406367015\" var=\" 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5364075409701906 0.0 0.0 0.19911528572567372 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"-0.8876791624430196 -0.9409064292072136 -0.2100936206436872 -0.32891776958029584 0.8696713237569915 -0.9400168133173552\"/>\n"
    + "   <xform weight=\"0.2851182169179224\" color=\"0.5419997164460817\" var=\" 0.0 0.0 0.9930407341455094 0.0 0.05911766388754136 0.0 0.0 0.0 0.0 0.2468515542190154 0.0 0.0 0.5578455044536699 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"0.49936197594901777 -0.05580911082845774 0.6228430205404019 -0.47615801751540543 -0.7944650650416405 0.3021377146219164\"/>\n"
    + "   <xform weight=\"0.4384998843205662\" color=\"0.5096731908919445\" var=\" 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.9759758248241182 0.0 0.0 0.0 0.0 0.8669136965846902 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"-0.10312657197899511 -0.5098818265687008 0.3277920462485 0.47921292001634197 -0.9920158529954315 -0.8658535273726113\"/>\n"
    + "</flame>\n"
    + "</test>\n"
    + "";
//    System.out.println(expexted);
//    System.out.println(flameJob_f.script);
    assertEquals(expexted, flameJob_f.script);

  }

}
