/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge;

import java.io.IOException;
import java.io.InputStream;

import kandid.util.Debug;

/**
 * Read error stream from child process in an seperate thread.
 * @author thomas jourdan
 *
 */
public class StderrReader extends Thread {

  private Process childProcess;
  private BatchJob batchJob;

  /**
   * 
   */
  public StderrReader(Process childProcess, BatchJob batchJob) {
    this.childProcess = childProcess;
    this.batchJob = batchJob;
  }

  /**
   * Reads error stream from child process.
   * @see java.lang.Runnable#run()
   */
  public void run() {
    try {
      int ch = 0;
      if (childProcess != null) {
        InputStream errorStream = childProcess.getErrorStream();
        batchJob.errorMessage.setLength(0);
        while (batchJob.state == BatchJob.stateRunning && ch >= 0) {
          ch = errorStream.read();
          if (ch >= 0)
            batchJob.errorMessage.append((char) ch);
            //!!if(Debug.enabled) System.err.print((char)ch);
        }
      }
    }
    catch (IOException exc) {
      Debug.stackTrace(exc);
    }
    catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

}
