/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;

import junit.framework.TestCase;
import kandid.calculation.bridge.flame.FlameJob;
import kandid.soup.ChromosomeType;
import kandid.soup.PopulationType;
import kandid.soup.test.SoupFactoryTest;
import kandid.soup.util.SoupFactory;
import kandid.util.Debug;

/**
 * @author thomas jourdan
 *
 */
public class FileBridgeTest extends TestCase {

  private static final int height = 200;
  private static final int width = 100;
  SoupFactory soupFactory;
  PopulationType population;
  ChromosomeType aChromosome;

  Dimension dim = new Dimension(width, height);

  /**
   * Constructor for FileBridgeTest.
   * @param name
   */
  public FileBridgeTest(String name) {
    super(name);
  }

  /* (non-Javadoc)
   * @see junit.framework.TestCase#setUp()
   */
  protected void setUp() throws Exception {
    super.setUp();
    soupFactory = SoupFactory.getSoupFactory();
    population = SoupFactoryTest.createRandomPopulation(soupFactory, "FlameIfs", "FlameCalculation", "kandid.colorator.RGBColorator");
    aChromosome = soupFactory.getChromosome(population, 0);

    dim = new Dimension(width, height);
  }

  public void testTryNice() {
    assertEquals(true, BridgeBase.tryNice());
  }
  
  public void testExecute() {
    FlameJob flameJob = new FlameJob();
    flameJob.createJob(aChromosome, dim, false, null, "png");
    FileBridge fileBridge = new FileBridge(flameJob);
    fileBridge.execute();
    fileBridge.waitFor();
    assertEquals(BatchJob.stateReady, flameJob.state);
    BufferedImage image = null;
    try {
      image = fileBridge.getImage();
    }
    catch (IOException exc) {
      Debug.stackTrace(exc);
      fail();
    }
    assertNotNull(image);
    assertEquals(height, image.getHeight());
    assertEquals(width, image.getWidth());
  }

  public void testDestroy() {
    FlameJob flameJob = new FlameJob();
    flameJob.createJob(aChromosome, dim, false, null, "png");
    FileBridge fileBridge = new FileBridge(flameJob);
    fileBridge.execute();
    fileBridge.destroy();
    assertEquals(BatchJob.stateDestroied, flameJob.state);
    BufferedImage image = null;
    try {
      image = fileBridge.getImage();
    }
    catch (IOException exc) {
      Debug.stackTrace(exc);
      fail();
    }
    assertNull(image);
  }

  public void testErrorMessage() {
    FlameJob flameJob = new FlameJob();
    flameJob.createJob(aChromosome, dim, false, null, "png");
    flameJob.script = flameJob.script.replace('<', '!');
    FileBridge fileBridge = new FileBridge(flameJob);
    fileBridge.execute();
    fileBridge.waitFor();
    assertTrue(flameJob.errorMessage.length() >= 0);
    System.out.println(flameJob.errorMessage.toString());
    assertTrue(flameJob.errorMessage.toString().contains("Failed to parse"));
  }

}
