/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import kandid.util.Debug;

/**
 * @author thomas jourdan
 *
 */
public class FileBridge extends BridgeBase implements Bridge {
  /**
   * @param batchJob
   */
  public FileBridge(BatchJob batchJob) {
    super(batchJob);
  }

  /* (non-Javadoc)
   * @see kandid.calculation.newbridge.NewBridge#getImage()
   */
  public BufferedImage getImage() throws IOException {
    BufferedImage importedImage = null;
    if(Debug.enabled && !(batchJob.state == BatchJob.stateReady || batchJob.state == BatchJob.stateDestroied)) {
      System.err.println("getImage() wrong state = " + batchJob.state);
    }
    if(batchJob.state == BatchJob.stateReady) {
      File imgFile = new File(batchJob.imageFileName);
      if(imgFile.exists()) {
        // get resulting image
        if(batchJob.preview) {
          if(Debug.enabled) System.out.println("reading preview: " + batchJob.imageFileName + " " + Debug.currentTime());
          //if(Debug.enabled) Debug.stackTrace(new Exception());
          BufferedImage unscaledImage = javax.imageio.ImageIO.read(imgFile);
          importedImage = new BufferedImage(batchJob.canvasSize.width, batchJob.canvasSize.height, BufferedImage.TYPE_INT_RGB);
          Graphics2D g2d = importedImage.createGraphics();
          g2d.drawImage(unscaledImage, scale, null);
        }
        else {
          if(Debug.enabled) System.out.println("reading final  : " + batchJob.imageFileName + " " + Debug.currentTime());
          //if(Debug.enabled) Debug.stackTrace(new Exception());
          importedImage = javax.imageio.ImageIO.read(imgFile);
        }
      }
    }
    return importedImage;
  }

  /**
   * Delete scratch files.
   */
  public void cleanUp() {
    if (!batchJob.doExport) {
      if(!Debug.enabled) {
        (new File(batchJob.scriptFileName)).delete();
      } 
      (new File(batchJob.imageFileName)).delete();
    }
  }

  /* (non-Javadoc)
   * @see kandid.calculation.newbridge.Bridge#recieve(java.awt.Graphics)
   */
  public boolean recieve(Graphics graphics) {
    return true;
  }
}
